/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.logging;

import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private int threshold;
    private String name;

    public AbstractLogger(int threshold, String name) {
        if (!this.isValidThreshold(threshold)) {
            throw new IllegalArgumentException("Threshold " + threshold + " is not valid");
        }
        this.threshold = threshold;
        this.name = name;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void debug(String message2) {
        this.debug(message2, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.threshold <= 0;
    }

    @Override
    public void info(String message2) {
        this.info(message2, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.threshold <= 1;
    }

    @Override
    public void warn(String message2) {
        this.warn(message2, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.threshold <= 2;
    }

    @Override
    public void error(String message2) {
        this.error(message2, null);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.threshold <= 3;
    }

    @Override
    public void fatalError(String message2) {
        this.fatalError(message2, null);
    }

    @Override
    public boolean isFatalErrorEnabled() {
        return this.threshold <= 4;
    }

    protected boolean isValidThreshold(int threshold) {
        if (threshold == 0) {
            return true;
        }
        if (threshold == 1) {
            return true;
        }
        if (threshold == 2) {
            return true;
        }
        if (threshold == 3) {
            return true;
        }
        if (threshold == 4) {
            return true;
        }
        return threshold == 5;
    }
}

