/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.TrackingRefUpdate;

public class RemoteRefUpdate {
    private ObjectId expectedOldObjectId;
    private final ObjectId newObjectId;
    private final String remoteName;
    private final TrackingRefUpdate trackingRefUpdate;
    private final String srcRef;
    private final boolean forceUpdate;
    private Status status;
    private boolean fastForward;
    private String message;
    private final Repository localDb;
    private RefUpdate localUpdate;

    public RemoteRefUpdate(Repository localDb, String srcRef, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        this(localDb, srcRef, srcRef != null ? localDb.resolve(srcRef) : ObjectId.zeroId(), remoteName, forceUpdate, localName, expectedOldObjectId);
    }

    public RemoteRefUpdate(Repository localDb, Ref srcRef, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        this(localDb, srcRef != null ? srcRef.getName() : null, srcRef != null ? srcRef.getObjectId() : null, remoteName, forceUpdate, localName, expectedOldObjectId);
    }

    public RemoteRefUpdate(Repository localDb, String srcRef, ObjectId srcId, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        if (remoteName == null) {
            throw new IllegalArgumentException(JGitText.get().remoteNameCannotBeNull);
        }
        if (srcId == null && srcRef != null) {
            throw new IOException(MessageFormat.format(JGitText.get().sourceRefDoesntResolveToAnyObject, srcRef));
        }
        this.srcRef = srcRef != null ? srcRef : (srcId != null && !srcId.equals(ObjectId.zeroId()) ? srcId.name() : null);
        this.newObjectId = srcId != null ? srcId : ObjectId.zeroId();
        this.remoteName = remoteName;
        this.forceUpdate = forceUpdate;
        if (localName != null && localDb != null) {
            this.localUpdate = localDb.updateRef(localName);
            this.localUpdate.setForceUpdate(true);
            this.localUpdate.setRefLogMessage("push", true);
            this.localUpdate.setNewObjectId(this.newObjectId);
            this.trackingRefUpdate = new TrackingRefUpdate(true, remoteName, localName, this.localUpdate.getOldObjectId() != null ? this.localUpdate.getOldObjectId() : ObjectId.zeroId(), this.newObjectId);
        } else {
            this.trackingRefUpdate = null;
        }
        this.localDb = localDb;
        this.expectedOldObjectId = expectedOldObjectId;
        this.status = Status.NOT_ATTEMPTED;
    }

    public RemoteRefUpdate(RemoteRefUpdate base, ObjectId newExpectedOldObjectId) throws IOException {
        this(base.localDb, base.srcRef, base.remoteName, base.forceUpdate, base.trackingRefUpdate == null ? null : base.trackingRefUpdate.getLocalName(), newExpectedOldObjectId);
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expectedOldObjectId;
    }

    public boolean isExpectingOldObjectId() {
        return this.expectedOldObjectId != null;
    }

    public ObjectId getNewObjectId() {
        return this.newObjectId;
    }

    public boolean isDelete() {
        return ObjectId.zeroId().equals(this.newObjectId);
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public TrackingRefUpdate getTrackingRefUpdate() {
        return this.trackingRefUpdate;
    }

    public String getSrcRef() {
        return this.srcRef;
    }

    public boolean hasTrackingRefUpdate() {
        return this.trackingRefUpdate != null;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isFastForward() {
        return this.fastForward;
    }

    public String getMessage() {
        return this.message;
    }

    void setExpectedOldObjectId(ObjectId id) {
        this.expectedOldObjectId = id;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    void setFastForward(boolean fastForward) {
        this.fastForward = fastForward;
    }

    void setMessage(String message2) {
        this.message = message2;
    }

    protected void updateTrackingRef(RevWalk walk) throws IOException {
        if (this.isDelete()) {
            this.trackingRefUpdate.setResult(this.localUpdate.delete(walk));
        } else {
            this.trackingRefUpdate.setResult(this.localUpdate.update(walk));
        }
    }

    public String toString() {
        return "RemoteRefUpdate[remoteName=" + this.remoteName + ", " + (Object)((Object)this.status) + ", " + (this.expectedOldObjectId != null ? this.expectedOldObjectId.name() : "(null)") + "..." + (this.newObjectId != null ? this.newObjectId.name() : "(null)") + (this.fastForward ? ", fastForward" : "") + ", srcRef=" + this.srcRef + (this.forceUpdate ? ", forceUpdate" : "") + ", message=" + (this.message != null ? "\"" + this.message + "\"" : "null") + "]";
    }

    public static enum Status {
        NOT_ATTEMPTED,
        UP_TO_DATE,
        REJECTED_NONFASTFORWARD,
        REJECTED_NODELETE,
        REJECTED_REMOTE_CHANGED,
        REJECTED_OTHER_REASON,
        NON_EXISTING,
        AWAITING_REPORT,
        OK;

    }
}

