/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.mozilla.javascript;

import org.gradle.internal.impldep.org.mozilla.javascript.ErrorReporter;
import org.gradle.internal.impldep.org.mozilla.javascript.EvaluatorException;
import org.gradle.internal.impldep.org.mozilla.javascript.ScriptRuntime;

class DefaultErrorReporter
implements ErrorReporter {
    static final DefaultErrorReporter instance = new DefaultErrorReporter();
    private boolean forEval;
    private ErrorReporter chainedReporter;

    private DefaultErrorReporter() {
    }

    static ErrorReporter forEval(ErrorReporter reporter) {
        DefaultErrorReporter r = new DefaultErrorReporter();
        r.forEval = true;
        r.chainedReporter = reporter;
        return r;
    }

    @Override
    public void warning(String message2, String sourceURI, int line, String lineText, int lineOffset) {
        if (this.chainedReporter != null) {
            this.chainedReporter.warning(message2, sourceURI, line, lineText, lineOffset);
        }
    }

    @Override
    public void error(String message2, String sourceURI, int line, String lineText, int lineOffset) {
        if (this.forEval) {
            String error = "SyntaxError";
            String TYPE_ERROR_NAME = "TypeError";
            String DELIMETER = ": ";
            String prefix = "TypeError: ";
            if (message2.startsWith("TypeError: ")) {
                error = "TypeError";
                message2 = message2.substring("TypeError: ".length());
            }
            throw ScriptRuntime.constructError(error, message2, sourceURI, line, lineText, lineOffset);
        }
        if (this.chainedReporter == null) {
            throw this.runtimeError(message2, sourceURI, line, lineText, lineOffset);
        }
        this.chainedReporter.error(message2, sourceURI, line, lineText, lineOffset);
    }

    @Override
    public EvaluatorException runtimeError(String message2, String sourceURI, int line, String lineText, int lineOffset) {
        if (this.chainedReporter != null) {
            return this.chainedReporter.runtimeError(message2, sourceURI, line, lineText, lineOffset);
        }
        return new EvaluatorException(message2, sourceURI, line, lineText, lineOffset);
    }
}

