/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.installation;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.installation.InstallRequest;
import org.gradle.internal.impldep.org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallResult {
    private final InstallRequest request;
    private Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private Collection<Metadata> metadata = new ArrayList<Metadata>();

    public InstallResult(InstallRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("install request has not been specified");
        }
        this.request = request;
    }

    public InstallRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public InstallResult setArtifacts(Collection<Artifact> artifacts2) {
        this.artifacts = artifacts2 == null ? new ArrayList<Artifact>() : artifacts2;
        return this;
    }

    public InstallResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public InstallResult setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata == null ? new ArrayList<Metadata>() : metadata;
        return this;
    }

    public InstallResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

