/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.repository;

import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepository;

public class NoLocalRepositoryManagerException
extends RepositoryException {
    private final LocalRepository repository;

    public NoLocalRepositoryManagerException(LocalRepository repository) {
        this(repository, NoLocalRepositoryManagerException.toMessage(repository));
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, String message2) {
        super(message2);
        this.repository = repository;
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, Throwable cause) {
        this(repository, NoLocalRepositoryManagerException.toMessage(repository), cause);
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, String message2, Throwable cause) {
        super(message2, cause);
        this.repository = repository;
    }

    private static String toMessage(LocalRepository repository) {
        if (repository != null) {
            return "No manager available for local repository (" + repository.getBasedir().getAbsolutePath() + ") of type " + repository.getContentType();
        }
        return "No connector available to access repository";
    }

    public LocalRepository getRepository() {
        return this.repository;
    }
}

