/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.transfer;

import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;

public class ChecksumFailureException
extends RepositoryException {
    private final String expected;
    private final String actual;

    public ChecksumFailureException(String expected, String actual) {
        super("Checksum validation failed, expected " + expected + " but is " + actual);
        this.expected = expected;
        this.actual = actual;
    }

    public ChecksumFailureException(String message2) {
        super(message2);
        this.actual = "";
        this.expected = "";
    }

    public ChecksumFailureException(Throwable cause) {
        super("Checksum validation failed, could not read expected checksum" + ChecksumFailureException.getMessage(": ", cause), cause);
        this.actual = "";
        this.expected = "";
    }

    public ChecksumFailureException(String message2, Throwable cause) {
        super(message2, cause);
        this.actual = "";
        this.expected = "";
    }

    public String getExpected() {
        return this.expected;
    }

    public String getActual() {
        return this.actual;
    }
}

