/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.version;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.internal.impldep.org.sonatype.aether.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericVersion
implements Version {
    private final String version;
    private final Item[] items;
    private final int hash;

    public GenericVersion(String version) {
        this.version = version;
        this.items = GenericVersion.parse(version);
        this.hash = Arrays.hashCode(this.items);
    }

    private static Item[] parse(String version) {
        ArrayList<Item> items = new ArrayList<Item>();
        Tokenizer tokenizer = new Tokenizer(version);
        while (tokenizer.next()) {
            Item item = new Item(tokenizer);
            items.add(item);
        }
        GenericVersion.trimPadding(items);
        return items.toArray(new Item[items.size()]);
    }

    private static void trimPadding(List<Item> items) {
        int end;
        Boolean number = null;
        for (int i = end = items.size() - 1; i > 0; --i) {
            Item item = items.get(i);
            if (!Boolean.valueOf(item.isNumber()).equals(number)) {
                end = i;
                number = item.isNumber();
            }
            if (end != i || i != items.size() - 1 && items.get(i - 1).isNumber() != item.isNumber() || item.compareTo(null) != 0) continue;
            items.remove(i);
            --end;
        }
    }

    @Override
    public int compareTo(Version obj) {
        Item[] these = this.items;
        Item[] those = ((GenericVersion)obj).items;
        boolean number = true;
        int index = 0;
        while (index < these.length || index < those.length) {
            if (index >= these.length) {
                return -GenericVersion.comparePadding(those, index, null);
            }
            if (index >= those.length) {
                return GenericVersion.comparePadding(these, index, null);
            }
            Item thisItem = these[index];
            Item thatItem = those[index];
            if (thisItem.isNumber() != thatItem.isNumber()) {
                if (number == thisItem.isNumber()) {
                    return GenericVersion.comparePadding(these, index, number);
                }
                return -GenericVersion.comparePadding(those, index, number);
            }
            int rel = thisItem.compareTo(thatItem);
            if (rel != 0) {
                return rel;
            }
            number = thisItem.isNumber();
            ++index;
        }
        return 0;
    }

    private static int comparePadding(Item[] items, int index, Boolean number) {
        int rel = 0;
        for (int i = index; i < items.length; ++i) {
            Item item = items[i];
            if (number != null && number.booleanValue() != item.isNumber() || (rel = item.compareTo(null)) != 0) break;
        }
        return rel;
    }

    public boolean equals(Object obj) {
        return obj instanceof GenericVersion && this.compareTo((GenericVersion)obj) == 0;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        return this.version;
    }

    static final class Item {
        private static final int KIND_BIGINT = 3;
        private static final int KIND_INT = 2;
        private static final int KIND_STRING = 1;
        private static final int KIND_QUALIFIER = 0;
        private static final Map<String, Integer> QUALIFIERS = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private final int kind;
        private final Object value;

        public Item(Tokenizer tokenizer) {
            String token = tokenizer.getToken();
            if (tokenizer.isNumber()) {
                try {
                    if (token.length() < 10) {
                        this.kind = 2;
                        this.value = Integer.parseInt(token);
                    }
                    this.kind = 3;
                    this.value = new BigInteger(token);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                Integer qualifier;
                if (tokenizer.isTerminatedByNumber() && token.length() == 1) {
                    switch (token.charAt(0)) {
                        case 'A': 
                        case 'a': {
                            token = "alpha";
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            token = "beta";
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            token = "milestone";
                        }
                    }
                }
                if ((qualifier = QUALIFIERS.get(token)) != null) {
                    this.kind = 0;
                    this.value = qualifier;
                } else {
                    this.kind = 1;
                    this.value = token.toLowerCase(Locale.ENGLISH);
                }
            }
        }

        public boolean isNumber() {
            return this.kind >= 2;
        }

        public int compareTo(Item that) {
            int rel;
            block11: {
                block10: {
                    if (that != null) break block10;
                    switch (this.kind) {
                        case 1: 
                        case 3: {
                            rel = 1;
                            break block11;
                        }
                        case 0: 
                        case 2: {
                            rel = (Integer)this.value;
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                    }
                }
                rel = this.kind - that.kind;
                if (rel == 0) {
                    switch (this.kind) {
                        case 3: {
                            rel = ((BigInteger)this.value).compareTo((BigInteger)that.value);
                            break;
                        }
                        case 0: 
                        case 2: {
                            rel = ((Integer)this.value).compareTo((Integer)that.value);
                            break;
                        }
                        case 1: {
                            rel = ((String)this.value).compareToIgnoreCase((String)that.value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                    }
                }
            }
            return rel;
        }

        public boolean equals(Object obj) {
            return obj instanceof Item && this.compareTo((Item)obj) == 0;
        }

        public int hashCode() {
            return this.value.hashCode() + this.kind * 31;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        static {
            QUALIFIERS.put("alpha", -5);
            QUALIFIERS.put("beta", -4);
            QUALIFIERS.put("milestone", -3);
            QUALIFIERS.put("cr", -2);
            QUALIFIERS.put("rc", -2);
            QUALIFIERS.put("snapshot", -1);
            QUALIFIERS.put("ga", 0);
            QUALIFIERS.put("final", 0);
            QUALIFIERS.put("", 0);
            QUALIFIERS.put("sp", 1);
        }
    }

    static final class Tokenizer {
        private final String version;
        private int index;
        private String token;
        private boolean number;
        private boolean terminatedByNumber;

        public Tokenizer(String version) {
            this.version = version.length() > 0 ? version : "0";
        }

        public String getToken() {
            return this.token;
        }

        public boolean isNumber() {
            return this.number;
        }

        public boolean isTerminatedByNumber() {
            return this.terminatedByNumber;
        }

        public boolean next() {
            int n = this.version.length();
            if (this.index >= n) {
                return false;
            }
            int state2 = -2;
            int start = this.index;
            int end = n;
            this.terminatedByNumber = false;
            while (this.index < n) {
                char c = this.version.charAt(this.index);
                if (c == '.' || c == '-') {
                    end = this.index++;
                    break;
                }
                int digit = Character.digit(c, 10);
                if (digit >= 0) {
                    if (state2 == -1) {
                        end = this.index;
                        this.terminatedByNumber = true;
                        break;
                    }
                    if (state2 == 0) {
                        ++start;
                    }
                    state2 = state2 > 0 || digit > 0 ? 1 : 0;
                } else {
                    if (state2 >= 0) {
                        end = this.index;
                        break;
                    }
                    state2 = -1;
                }
                ++this.index;
            }
            if (end - start > 0) {
                this.token = this.version.substring(start, end);
                this.number = state2 >= 0;
            } else {
                this.token = "0";
                this.number = true;
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.token);
        }
    }
}

