/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.testng.collections.Lists;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(boolean condition, String message2) {
        if (!condition) {
            Assert.failNotEquals(condition, Boolean.TRUE, message2);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition, null);
    }

    public static void assertFalse(boolean condition, String message2) {
        if (condition) {
            Assert.failNotEquals(condition, Boolean.FALSE, message2);
        }
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(condition, null);
    }

    public static void fail(String message2, Throwable realCause) {
        AssertionError ae = new AssertionError((Object)message2);
        ((Throwable)((Object)ae)).initCause(realCause);
        throw ae;
    }

    public static void fail(String message2) {
        throw new AssertionError((Object)message2);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(Object actual, Object expected, String message2) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null) {
            if (expected.getClass().isArray()) {
                Assert.assertArrayEquals(actual, expected, message2);
                return;
            }
            if (expected.equals(actual)) {
                return;
            }
        }
        Assert.failNotEquals(actual, expected, message2);
    }

    private static void assertArrayEquals(Object actual, Object expected, String message2) {
        if (actual.getClass().isArray()) {
            int expectedLength = Array.getLength(expected);
            if (expectedLength == Array.getLength(actual)) {
                for (int i = 0; i < expectedLength; ++i) {
                    Object _actual = Array.get(actual, i);
                    Object _expected = Array.get(expected, i);
                    try {
                        Assert.assertEquals(_actual, _expected);
                        continue;
                    }
                    catch (AssertionError ae) {
                        Assert.failNotEquals(actual, expected, message2 == null ? "" : message2 + " (values as index " + i + " are not the same)");
                    }
                }
                return;
            }
            Assert.failNotEquals(Array.getLength(actual), expectedLength, message2 == null ? "" : message2 + " (Array lengths are not the same)");
        }
        Assert.failNotEquals(actual, expected, message2);
    }

    public static void assertEquals(Object actual, Object expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(String actual, String expected, String message2) {
        Assert.assertEquals((Object)actual, (Object)expected, message2);
    }

    public static void assertEquals(String actual, String expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(double actual, double expected, double delta, String message2) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                Assert.failNotEquals(new Double(actual), new Double(expected), message2);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(new Double(actual), new Double(expected), message2);
        }
    }

    public static void assertEquals(double actual, double expected, double delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(float actual, float expected, float delta, String message2) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                Assert.failNotEquals(new Float(actual), new Float(expected), message2);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(new Float(actual), new Float(expected), message2);
        }
    }

    public static void assertEquals(float actual, float expected, float delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(long actual, long expected, String message2) {
        Assert.assertEquals((Object)actual, (Object)expected, message2);
    }

    public static void assertEquals(long actual, long expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(boolean actual, boolean expected, String message2) {
        Assert.assertEquals((Object)actual, (Object)expected, message2);
    }

    public static void assertEquals(boolean actual, boolean expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(byte actual, byte expected, String message2) {
        Assert.assertEquals((Object)actual, (Object)expected, message2);
    }

    public static void assertEquals(byte actual, byte expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(char actual, char expected, String message2) {
        Assert.assertEquals(Character.valueOf(actual), Character.valueOf(expected), message2);
    }

    public static void assertEquals(char actual, char expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(short actual, short expected, String message2) {
        Assert.assertEquals((Object)actual, (Object)expected, message2);
    }

    public static void assertEquals(short actual, short expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(int actual, int expected, String message2) {
        Assert.assertEquals((Object)actual, (Object)expected, message2);
    }

    public static void assertEquals(int actual, int expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object, null);
    }

    public static void assertNotNull(Object object, String message2) {
        if (object == null) {
            String formatted = "";
            if (message2 != null) {
                formatted = message2 + " ";
            }
            Assert.fail(formatted + "expected object to not be null");
        }
        Assert.assertTrue(object != null, message2);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object, null);
    }

    public static void assertNull(Object object, String message2) {
        if (object != null) {
            Assert.failNotSame(object, null, message2);
        }
    }

    public static void assertSame(Object actual, Object expected, String message2) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(actual, expected, message2);
    }

    public static void assertSame(Object actual, Object expected) {
        Assert.assertSame(actual, expected, null);
    }

    public static void assertNotSame(Object actual, Object expected, String message2) {
        if (expected == actual) {
            Assert.failSame(actual, expected, message2);
        }
    }

    public static void assertNotSame(Object actual, Object expected) {
        Assert.assertNotSame(actual, expected, null);
    }

    private static void failSame(Object actual, Object expected, String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        Assert.fail(formatted + "expected not same with:<" + expected + "> but was same:<" + actual + ">");
    }

    private static void failNotSame(Object actual, Object expected, String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        Assert.fail(formatted + "expected:<" + expected + "> but was:<" + actual + ">");
    }

    private static void failNotEquals(Object actual, Object expected, String message2) {
        Assert.fail(Assert.format(actual, expected, message2));
    }

    static String format(Object actual, Object expected, String message2) {
        String formatted = "";
        if (null != message2) {
            formatted = message2 + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    public static void assertEquals(Collection actual, Collection expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Collection actual, Collection expected, String message2) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message2 != null) {
                Assert.fail(message2);
            } else {
                Assert.fail("Collections not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Assert.assertEquals(actual.size(), expected.size(), message2 + ": lists don't have the same size");
        Iterator actIt = actual.iterator();
        Iterator expIt = expected.iterator();
        int i = -1;
        while (actIt.hasNext() && expIt.hasNext()) {
            Object e = expIt.next();
            Object a = actIt.next();
            String explanation = "Lists differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage = message2 == null ? explanation : message2 + ": " + explanation;
            Assert.assertEquals(a, e, errorMessage);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected, String message2) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (message2 != null) {
                Assert.fail(message2);
            } else {
                Assert.fail("Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual));
            }
        }
        Assert.assertEquals(Arrays.asList(actual), Arrays.asList(expected), message2);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected, String message2) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            Assert.failAssertNoEqual(actual, expected, "Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual), message2);
        }
        if (actual.length != expected.length) {
            Assert.failAssertNoEqual(actual, expected, "Arrays do not have the same size:" + actual.length + " != " + expected.length, message2);
        }
        List actualCollection = Lists.newArrayList();
        for (Object a : actual) {
            actualCollection.add(a);
        }
        for (Object o : expected) {
            actualCollection.remove(o);
        }
        if (actualCollection.size() != 0) {
            Assert.failAssertNoEqual(actual, expected, "Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual), message2);
        }
    }

    private static void failAssertNoEqual(Object[] actual, Object[] expected, String message2, String defaultMessage) {
        if (message2 != null) {
            Assert.fail(message2);
        } else {
            Assert.fail(defaultMessage);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected) {
        Assert.assertEqualsNoOrder(actual, expected, null);
    }

    public static void assertEquals(byte[] actual, byte[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(byte[] actual, byte[] expected, String message2) {
        if (expected == actual) {
            return;
        }
        if (null == expected) {
            Assert.fail("expected a null array, but not null found. " + message2);
        }
        if (null == actual) {
            Assert.fail("expected not null array, but null found. " + message2);
        }
        Assert.assertEquals(actual.length, expected.length, "arrays don't have the same size. " + message2);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail("arrays differ firstly at element [" + i + "]; " + "expected value is <" + expected[i] + "> but was <" + actual[i] + ">. " + message2);
        }
    }

    public static void assertEquals(Set actual, Set expected) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            Assert.fail("Sets not equal: expected: " + expected + " and actual: " + actual);
        }
        if (!((Object)actual).equals(expected)) {
            Assert.fail("Sets differ: expected " + expected + " but got " + actual);
        }
    }

    public static void assertEquals(Map actual, Map expected) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            Assert.fail("Maps not equal: expected: " + expected + " and actual: " + actual);
        }
        if (actual.size() != expected.size()) {
            Assert.fail("Maps do not have the same size:" + actual.size() + " != " + expected.size());
        }
        Set entrySet = actual.entrySet();
        for (Map.Entry entry : entrySet) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expectedValue = expected.get(key);
            Assert.assertEquals(value, expectedValue, "Maps do not match for key:" + key + " actual:" + value + " expected:" + expectedValue);
        }
    }

    public static void assertNotEquals(Object actual1, Object actual2, String message2) {
        boolean fail = false;
        try {
            Assert.assertEquals(actual1, actual2);
            fail = true;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        if (fail) {
            Assert.fail(message2);
        }
    }

    public static void assertNotEquals(Object actual1, Object actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(String actual1, String actual2, String message2) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message2);
    }

    static void assertNotEquals(String actual1, String actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(long actual1, long actual2, String message2) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message2);
    }

    static void assertNotEquals(long actual1, long actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(boolean actual1, boolean actual2, String message2) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message2);
    }

    static void assertNotEquals(boolean actual1, boolean actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(byte actual1, byte actual2, String message2) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message2);
    }

    static void assertNotEquals(byte actual1, byte actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(char actual1, char actual2, String message2) {
        Assert.assertNotEquals(Character.valueOf(actual1), Character.valueOf(actual2), message2);
    }

    static void assertNotEquals(char actual1, char actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(short actual1, short actual2, String message2) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message2);
    }

    static void assertNotEquals(short actual1, short actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(int actual1, int actual2, String message2) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message2);
    }

    static void assertNotEquals(int actual1, int actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    public static void assertNotEquals(float actual1, float actual2, float delta, String message2) {
        boolean fail = false;
        try {
            Assert.assertEquals(actual1, actual2, delta, message2);
            fail = true;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        if (fail) {
            Assert.fail(message2);
        }
    }

    public static void assertNotEquals(float actual1, float actual2, float delta) {
        Assert.assertNotEquals(actual1, actual2, delta, null);
    }

    public static void assertNotEquals(double actual1, double actual2, double delta, String message2) {
        boolean fail = false;
        try {
            Assert.assertEquals(actual1, actual2, delta, message2);
            fail = true;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        if (fail) {
            Assert.fail(message2);
        }
    }

    public static void assertNotEquals(double actual1, double actual2, double delta) {
        Assert.assertNotEquals(actual1, actual2, delta, null);
    }
}

