/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng;

import java.io.File;
import java.io.IOException;

public class FileAssert {
    private FileAssert() {
    }

    public static void assertDirectory(File tstvalue, String message2) {
        boolean condition = false;
        try {
            condition = tstvalue.isDirectory();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileType(tstvalue), "Directory", message2);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileType(tstvalue), "Directory", message2);
        }
    }

    public static void assertDirectory(File tstvalue) {
        FileAssert.assertDirectory(tstvalue, null);
    }

    public static void assertFile(File tstvalue, String message2) {
        boolean condition = false;
        try {
            condition = tstvalue.isFile();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileType(tstvalue), "File", message2);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileType(tstvalue), "File", message2);
        }
    }

    public static void assertFile(File tstvalue) {
        FileAssert.assertFile(tstvalue, null);
    }

    public static void assertLength(File tstvalue, long expected, String message2) {
        long actual = -1L;
        try {
            actual = tstvalue.isDirectory() ? (long)tstvalue.list().length : tstvalue.length();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, String.valueOf(actual), String.valueOf(expected), message2);
        }
        if (actual != expected) {
            FileAssert.failFile(tstvalue, String.valueOf(actual), String.valueOf(expected), message2);
        }
    }

    public static void assertLength(File tstvalue, long expected) {
        FileAssert.assertLength(tstvalue, expected, null);
    }

    public static void assertMinLength(File tstvalue, long expected, String message2) {
        long actual = -1L;
        try {
            actual = tstvalue.isDirectory() ? (long)tstvalue.list().length : tstvalue.length();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, String.valueOf(actual), "at least " + String.valueOf(expected), message2);
        }
        if (actual < expected) {
            FileAssert.failFile(tstvalue, String.valueOf(actual), "at least " + String.valueOf(expected), message2);
        }
    }

    public static void assertMinLength(File tstvalue, long expected) {
        FileAssert.assertMinLength(tstvalue, expected, null);
    }

    public static void assertMaxLength(File tstvalue, long expected, String message2) {
        long actual = -1L;
        try {
            actual = tstvalue.isDirectory() ? (long)tstvalue.list().length : tstvalue.length();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, String.valueOf(actual), "at most " + String.valueOf(expected), message2);
        }
        if (actual > expected) {
            FileAssert.failFile(tstvalue, String.valueOf(actual), "at most " + String.valueOf(expected), message2);
        }
    }

    public static void assertMaxLength(File tstvalue, long expected) {
        FileAssert.assertMaxLength(tstvalue, expected, null);
    }

    public static void assertReadable(File tstvalue, String message2) {
        boolean condition = false;
        try {
            condition = tstvalue.canRead();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileAccess(tstvalue), "Read Access", message2);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileAccess(tstvalue), "Read Access", message2);
        }
    }

    public static void assertReadable(File tstvalue) {
        FileAssert.assertReadable(tstvalue, null);
    }

    public static void assertWriteable(File tstvalue, String message2) {
        boolean condition = false;
        try {
            condition = tstvalue.canWrite();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileAccess(tstvalue), "Write Access", message2);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileAccess(tstvalue), "Write Access", message2);
        }
    }

    public static void assertWriteable(File tstvalue) {
        FileAssert.assertReadable(tstvalue, null);
    }

    public static void assertReadWrite(File tstvalue, String message2) {
        boolean condition = false;
        try {
            condition = tstvalue.canRead() && tstvalue.canWrite();
        }
        catch (SecurityException e) {
            FileAssert.failSecurity(e, tstvalue, FileAssert.fileAccess(tstvalue), "Read/Write Access", message2);
        }
        if (!condition) {
            FileAssert.failFile(tstvalue, FileAssert.fileAccess(tstvalue), "Read/Write Access", message2);
        }
    }

    public static void assertReadWrite(File tstvalue) {
        FileAssert.assertReadWrite(tstvalue, null);
    }

    public static void fail(String message2, Throwable realCause) {
        AssertionError ae = new AssertionError((Object)message2);
        ((Throwable)((Object)ae)).initCause(realCause);
        throw ae;
    }

    public static void fail(String message2) {
        throw new AssertionError((Object)message2);
    }

    public static void fail() {
        FileAssert.fail(null);
    }

    private static void failFile(File path, String actual, String expected, String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        FileAssert.fail(formatted + "expected <" + expected + "> but was <" + FileAssert.toString(path) + ">" + (expected != null ? "<" + expected + ">" : ""));
    }

    private static void failSecurity(Exception e, File path, String actual, String expected, String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        FileAssert.fail(formatted + "expected <" + expected + "> but was <" + FileAssert.toString(path) + ">" + "<" + (e != null && e.getMessage() != null && e.getMessage().length() > 0 ? e.getMessage() : "not authorized by JVM") + ">");
    }

    private static String fileType(File path) {
        try {
            if (!path.exists()) {
                return "Non existant";
            }
            if (path.isDirectory()) {
                return "Directory";
            }
            if (path.isFile()) {
                return "File";
            }
            return "Special File";
        }
        catch (SecurityException e) {
            return "Unauthorized";
        }
    }

    private static String fileAccess(File path) {
        try {
            if (!path.exists()) {
                return "Non existant";
            }
            if (path.canWrite() && path.canRead()) {
                return "Read/Write Access";
            }
            if (path.canRead()) {
                return "Read only Access";
            }
            if (path.canWrite()) {
                return "Write only Access";
            }
            return "No Access";
        }
        catch (SecurityException e) {
            return "Unauthorized";
        }
    }

    private static String toString(File path) {
        try {
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            return path.getAbsolutePath();
        }
    }
}

