/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.internal;

import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.testng.IAttributes;
import org.gradle.internal.impldep.org.testng.IClass;
import org.gradle.internal.impldep.org.testng.ITest;
import org.gradle.internal.impldep.org.testng.ITestNGMethod;
import org.gradle.internal.impldep.org.testng.ITestResult;
import org.gradle.internal.impldep.org.testng.Reporter;
import org.gradle.internal.impldep.org.testng.internal.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResult
implements ITestResult {
    private static final long serialVersionUID = 6273017418233324556L;
    private IClass m_testClass = null;
    private ITestNGMethod m_method = null;
    private int m_status = -1;
    private Throwable m_throwable = null;
    private long m_startMillis = 0L;
    private long m_endMillis = 0L;
    private String m_name = null;
    private String m_host;
    private transient Object[] m_parameters = new Object[0];
    private transient Object m_instance;
    private IAttributes m_attributes = new Attributes();

    public TestResult() {
    }

    public TestResult(IClass testClass, Object instance, ITestNGMethod method, Throwable throwable, long start, long end) {
        this.init(testClass, instance, method, throwable, start, end);
    }

    public void init(IClass testClass, Object instance, ITestNGMethod method, Throwable throwable, long start, long end) {
        this.m_testClass = testClass;
        this.m_throwable = throwable;
        if (null == this.m_throwable) {
            this.m_status = 1;
        }
        this.m_startMillis = start;
        this.m_endMillis = end;
        this.m_method = method;
        this.m_instance = instance;
        if (this.m_instance == null) {
            this.m_name = this.m_method.getMethodName();
        } else if (this.m_instance instanceof ITest) {
            this.m_name = ((ITest)this.m_instance).getTestName();
        } else {
            String string2 = this.m_instance.toString();
            this.m_name = this.getMethod().getMethodName();
            try {
                if (!Object.class.getMethod("toString", new Class[0]).equals(this.m_instance.getClass().getMethod("toString", new Class[0]))) {
                    this.m_name = this.m_name + " on instance " + string2;
                }
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
    }

    private static void ppp(String s) {
        System.out.println("[TestResult] " + s);
    }

    @Override
    public void setEndMillis(long millis) {
        this.m_endMillis = millis;
    }

    @Override
    public String getTestName() {
        if (this.m_instance instanceof ITest) {
            return ((ITest)this.m_instance).getTestName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(ITestNGMethod method) {
        this.m_method = method;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        this.m_status = status;
    }

    @Override
    public boolean isSuccess() {
        return 1 == this.m_status;
    }

    @Override
    public IClass getTestClass() {
        return this.m_testClass;
    }

    public void setTestClass(IClass testClass) {
        this.m_testClass = testClass;
    }

    @Override
    public Throwable getThrowable() {
        return this.m_throwable;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    @Override
    public long getEndMillis() {
        return this.m_endMillis;
    }

    @Override
    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String toString() {
        List<String> output = Reporter.getOutput(this);
        String result = "[TestResult: " + this.getName() + " STATUS:" + this.toString(this.m_status) + " METHOD:" + this.m_method;
        result = result + (output != null && output.size() > 0 ? output.get(0) : "]\n");
        return result;
    }

    private String toString(int status) {
        switch (status) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILURE";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS WITHIN PERCENTAGE";
            }
            case 16: {
                return "STARTED";
            }
        }
        throw new RuntimeException();
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.m_parameters = parameters;
    }

    @Override
    public Object getInstance() {
        return this.m_instance;
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    @Override
    public int compareTo(ITestResult comparison) {
        if (this.getStartMillis() > comparison.getStartMillis()) {
            return 1;
        }
        if (this.getStartMillis() < comparison.getStartMillis()) {
            return -1;
        }
        return 0;
    }
}

