/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Map;
import org.gradle.internal.impldep.org.testng.IAnnotationTransformer;
import org.gradle.internal.impldep.org.testng.IAnnotationTransformer2;
import org.gradle.internal.impldep.org.testng.annotations.AfterClass;
import org.gradle.internal.impldep.org.testng.annotations.AfterGroups;
import org.gradle.internal.impldep.org.testng.annotations.AfterMethod;
import org.gradle.internal.impldep.org.testng.annotations.AfterSuite;
import org.gradle.internal.impldep.org.testng.annotations.AfterTest;
import org.gradle.internal.impldep.org.testng.annotations.BeforeClass;
import org.gradle.internal.impldep.org.testng.annotations.BeforeGroups;
import org.gradle.internal.impldep.org.testng.annotations.BeforeMethod;
import org.gradle.internal.impldep.org.testng.annotations.BeforeSuite;
import org.gradle.internal.impldep.org.testng.annotations.BeforeTest;
import org.gradle.internal.impldep.org.testng.annotations.Configuration;
import org.gradle.internal.impldep.org.testng.annotations.DataProvider;
import org.gradle.internal.impldep.org.testng.annotations.ExpectedExceptions;
import org.gradle.internal.impldep.org.testng.annotations.Factory;
import org.gradle.internal.impldep.org.testng.annotations.IAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.IConfigurationAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.IDataProviderAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.IExpectedExceptionsAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.IFactoryAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.IObjectFactoryAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.IParametersAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.ITestAnnotation;
import org.gradle.internal.impldep.org.testng.annotations.Listeners;
import org.gradle.internal.impldep.org.testng.annotations.ObjectFactory;
import org.gradle.internal.impldep.org.testng.annotations.Optional;
import org.gradle.internal.impldep.org.testng.annotations.Parameters;
import org.gradle.internal.impldep.org.testng.annotations.Test;
import org.gradle.internal.impldep.org.testng.annotations.TestInstance;
import org.gradle.internal.impldep.org.testng.collections.Maps;
import org.gradle.internal.impldep.org.testng.internal.annotations.IAfterClass;
import org.gradle.internal.impldep.org.testng.internal.annotations.IAfterGroups;
import org.gradle.internal.impldep.org.testng.internal.annotations.IAfterMethod;
import org.gradle.internal.impldep.org.testng.internal.annotations.IAfterSuite;
import org.gradle.internal.impldep.org.testng.internal.annotations.IAfterTest;
import org.gradle.internal.impldep.org.testng.internal.annotations.IAnnotationFinder;
import org.gradle.internal.impldep.org.testng.internal.annotations.IBeforeClass;
import org.gradle.internal.impldep.org.testng.internal.annotations.IBeforeGroups;
import org.gradle.internal.impldep.org.testng.internal.annotations.IBeforeMethod;
import org.gradle.internal.impldep.org.testng.internal.annotations.IBeforeSuite;
import org.gradle.internal.impldep.org.testng.internal.annotations.IBeforeTest;
import org.gradle.internal.impldep.org.testng.internal.annotations.IListeners;
import org.gradle.internal.impldep.org.testng.internal.annotations.JDK15TagFactory;

public class JDK15AnnotationFinder
implements IAnnotationFinder {
    private JDK15TagFactory m_tagFactory = new JDK15TagFactory();
    private Map<Class<?>, Class<?>> m_annotationMap = Maps.newHashMap();
    private IAnnotationTransformer m_transformer = null;
    private Map<Pair, IAnnotation> m_annotations = Maps.newHashMap();

    public JDK15AnnotationFinder(IAnnotationTransformer transformer) {
        this.m_transformer = transformer;
        this.m_annotationMap.put(IConfigurationAnnotation.class, Configuration.class);
        this.m_annotationMap.put(IDataProviderAnnotation.class, DataProvider.class);
        this.m_annotationMap.put(IExpectedExceptionsAnnotation.class, ExpectedExceptions.class);
        this.m_annotationMap.put(IFactoryAnnotation.class, Factory.class);
        this.m_annotationMap.put(IObjectFactoryAnnotation.class, ObjectFactory.class);
        this.m_annotationMap.put(IParametersAnnotation.class, Parameters.class);
        this.m_annotationMap.put(ITestAnnotation.class, Test.class);
        this.m_annotationMap.put(IBeforeSuite.class, BeforeSuite.class);
        this.m_annotationMap.put(IAfterSuite.class, AfterSuite.class);
        this.m_annotationMap.put(IBeforeTest.class, BeforeTest.class);
        this.m_annotationMap.put(IAfterTest.class, AfterTest.class);
        this.m_annotationMap.put(IBeforeClass.class, BeforeClass.class);
        this.m_annotationMap.put(IAfterClass.class, AfterClass.class);
        this.m_annotationMap.put(IBeforeGroups.class, BeforeGroups.class);
        this.m_annotationMap.put(IAfterGroups.class, AfterGroups.class);
        this.m_annotationMap.put(IBeforeMethod.class, BeforeMethod.class);
        this.m_annotationMap.put(IAfterMethod.class, AfterMethod.class);
        this.m_annotationMap.put(IListeners.class, Listeners.class);
    }

    private Annotation findAnnotationInSuperClasses(Class cls, Class a) {
        if (a.equals(Listeners.class)) {
            return cls.getAnnotation(a);
        }
        while (cls != null) {
            Object result = cls.getAnnotation(a);
            if (result != null) {
                return result;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public IAnnotation findAnnotation(Method m, Class annotationClass) {
        Class<?> a = this.m_annotationMap.get(annotationClass);
        assert (a != null) : "Annotation class not found:" + annotationClass;
        IAnnotation result = this.findAnnotation(m.getDeclaringClass(), (Annotation)m.getAnnotation(a), annotationClass, null, null, m);
        return result;
    }

    private void transform(IAnnotation a, Class testClass, Constructor testConstructor, Method testMethod) {
        if (a instanceof ITestAnnotation) {
            this.m_transformer.transform((ITestAnnotation)a, testClass, testConstructor, testMethod);
        } else if (this.m_transformer instanceof IAnnotationTransformer2) {
            IAnnotationTransformer2 transformer2 = (IAnnotationTransformer2)this.m_transformer;
            if (a instanceof IConfigurationAnnotation) {
                IConfigurationAnnotation configuration = (IConfigurationAnnotation)a;
                transformer2.transform(configuration, testClass, testConstructor, testMethod);
            } else if (a instanceof IDataProviderAnnotation) {
                transformer2.transform((IDataProviderAnnotation)a, testMethod);
            } else if (a instanceof IFactoryAnnotation) {
                transformer2.transform((IFactoryAnnotation)a, testMethod);
            }
        }
    }

    public IAnnotation findAnnotation(Class cls, Class annotationClass) {
        Class<?> a = this.m_annotationMap.get(annotationClass);
        if (a == null) {
            throw new AssertionError((Object)("Class " + annotationClass + " doesn't have an IAnnotation"));
        }
        IAnnotation result = this.findAnnotation(cls, this.findAnnotationInSuperClasses(cls, a), annotationClass, cls, null, null);
        return result;
    }

    public IAnnotation findAnnotation(Constructor m, Class annotationClass) {
        Class<?> a = this.m_annotationMap.get(annotationClass);
        IAnnotation result = this.findAnnotation(m.getDeclaringClass(), (Annotation)m.getAnnotation(a), annotationClass, null, m, null);
        return result;
    }

    private IAnnotation findAnnotation(Class cls, Annotation a, Class annotationClass, Class testClass, Constructor testConstructor, Method testMethod) {
        IAnnotation result = null;
        Pair<Annotation, GenericDeclaration> p = testClass != null ? new Pair<Annotation, Class>(a, testClass) : (testConstructor != null ? new Pair<Annotation, Constructor>(a, testConstructor) : new Pair<Annotation, Method>(a, testMethod));
        result = this.m_annotations.get(p);
        if (result == null) {
            result = this.m_tagFactory.createTag(cls, a, annotationClass, this.m_transformer);
            this.m_annotations.put(p, result);
            this.transform(result, testClass, testConstructor, testMethod);
        }
        return result;
    }

    private void ppp(String string2) {
        System.out.println("[JDK15AnnotationFinder] " + string2);
    }

    public boolean hasTestInstance(Method method, int i) {
        boolean result = false;
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length > 0 && annotations[i].length > 0) {
            Annotation a = annotations[i][0];
            result = a instanceof TestInstance;
        }
        return result;
    }

    public String[] findOptionalValues(Method method) {
        return this.optionalValues(method.getParameterAnnotations());
    }

    public String[] findOptionalValues(Constructor method) {
        return this.optionalValues(method.getParameterAnnotations());
    }

    private String[] optionalValues(Annotation[][] annotations) {
        String[] result = new String[annotations.length];
        block0: for (int i = 0; i < annotations.length; ++i) {
            for (Annotation a : annotations[i]) {
                if (!(a instanceof Optional)) continue;
                result[i] = ((Optional)a).value();
                continue block0;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
                return false;
            }
            return !(this.b == null ? other.b != null : !this.b.equals(other.b));
        }
    }
}

