/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.tomlj;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.gradle.internal.impldep.org.antlr.v4.runtime.BaseErrorListener;
import org.gradle.internal.impldep.org.antlr.v4.runtime.InputMismatchException;
import org.gradle.internal.impldep.org.antlr.v4.runtime.NoViableAltException;
import org.gradle.internal.impldep.org.antlr.v4.runtime.Parser;
import org.gradle.internal.impldep.org.antlr.v4.runtime.RecognitionException;
import org.gradle.internal.impldep.org.antlr.v4.runtime.Recognizer;
import org.gradle.internal.impldep.org.antlr.v4.runtime.Token;
import org.gradle.internal.impldep.org.antlr.v4.runtime.misc.IntervalSet;
import org.gradle.internal.impldep.org.tomlj.ErrorReporter;
import org.gradle.internal.impldep.org.tomlj.TokenName;
import org.gradle.internal.impldep.org.tomlj.Toml;
import org.gradle.internal.impldep.org.tomlj.TomlParseError;
import org.gradle.internal.impldep.org.tomlj.TomlPosition;

final class AccumulatingErrorListener
extends BaseErrorListener
implements ErrorReporter {
    private final List<TomlParseError> errors = new ArrayList<TomlParseError>();

    AccumulatingErrorListener() {
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPosition, String msg, RecognitionException e) {
        TomlPosition position = TomlPosition.positionAt(line, charPosition + 1);
        if (e instanceof InputMismatchException || e instanceof NoViableAltException) {
            String message2 = this.getMessage(e.getOffendingToken(), AccumulatingErrorListener.getExpected(e));
            this.reportError(message2, position);
            return;
        }
        if (offendingSymbol instanceof Token && recognizer instanceof Parser) {
            String message3 = this.getMessage((Token)offendingSymbol, AccumulatingErrorListener.getExpected(((Parser)recognizer).getExpectedTokens()));
            this.reportError(message3, position);
            return;
        }
        this.reportError(msg, position);
    }

    @Override
    public void reportError(TomlParseError error) {
        this.errors.add(error);
    }

    private void reportError(String message2, TomlPosition position) {
        this.reportError(new TomlParseError(message2, position));
    }

    List<TomlParseError> errors() {
        return this.errors;
    }

    private String getMessage(Token token, String expected) {
        return "Unexpected " + AccumulatingErrorListener.getTokenName(token) + ", expected " + expected;
    }

    private static String getTokenName(Token token) {
        int tokenType = token.getType();
        switch (tokenType) {
            case 16: {
                return "end of line";
            }
            case -1: {
                return "end of input";
            }
        }
        return "'" + Toml.tomlEscape(token.getText()) + '\'';
    }

    private static String getExpected(RecognitionException e) {
        IntervalSet expectedTokens = e.getExpectedTokens();
        return AccumulatingErrorListener.getExpected(expectedTokens);
    }

    private static String getExpected(IntervalSet expectedTokens) {
        List sortedNames = expectedTokens.getIntervals().stream().flatMap(i -> IntStream.rangeClosed(i.a, i.b).boxed()).flatMap(TokenName::namesForToken).sorted().distinct().map(TokenName::displayName).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        int count = sortedNames.size();
        for (int i2 = 0; i2 < count; ++i2) {
            builder.append((String)sortedNames.get(i2));
            if (i2 < count - 2) {
                builder.append(", ");
                continue;
            }
            if (i2 != count - 2) continue;
            if (count >= 3) {
                builder.append(',');
            }
            builder.append(" or ");
        }
        return builder.toString();
    }
}

