/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.tomlj;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.org.antlr.v4.runtime.CharStream;
import org.gradle.internal.impldep.org.antlr.v4.runtime.CharStreams;
import org.gradle.internal.impldep.org.antlr.v4.runtime.CommonTokenStream;
import org.gradle.internal.impldep.org.tomlj.AccumulatingErrorListener;
import org.gradle.internal.impldep.org.tomlj.KeyVisitor;
import org.gradle.internal.impldep.org.tomlj.LineVisitor;
import org.gradle.internal.impldep.org.tomlj.TomlParseError;
import org.gradle.internal.impldep.org.tomlj.TomlParseResult;
import org.gradle.internal.impldep.org.tomlj.TomlPosition;
import org.gradle.internal.impldep.org.tomlj.TomlTable;
import org.gradle.internal.impldep.org.tomlj.TomlVersion;
import org.gradle.internal.impldep.org.tomlj.internal.TomlLexer;
import org.gradle.internal.impldep.org.tomlj.internal.TomlParser;

final class Parser {
    private Parser() {
    }

    static TomlParseResult parse(CharStream stream, TomlVersion version) {
        TomlLexer lexer = new TomlLexer(stream);
        TomlParser parser = new TomlParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        final AccumulatingErrorListener errorListener = new AccumulatingErrorListener();
        parser.addErrorListener(errorListener);
        TomlParser.TomlContext tree = parser.toml();
        final TomlTable table = tree.accept(new LineVisitor(errorListener, version));
        return new TomlParseResult(){

            @Override
            public int size() {
                return table.size();
            }

            @Override
            public boolean isEmpty() {
                return table.isEmpty();
            }

            @Override
            public Set<String> keySet() {
                return table.keySet();
            }

            @Override
            public Set<List<String>> keyPathSet(boolean includeTables) {
                return table.keyPathSet(includeTables);
            }

            @Override
            @Nullable
            public Object get(List<String> path) {
                return table.get(path);
            }

            @Override
            @Nullable
            public TomlPosition inputPositionOf(List<String> path) {
                return table.inputPositionOf(path);
            }

            @Override
            public Map<String, Object> toMap() {
                return table.toMap();
            }

            @Override
            public List<TomlParseError> errors() {
                return errorListener.errors();
            }
        };
    }

    static List<String> parseDottedKey(String dottedKey) {
        TomlLexer lexer = new TomlLexer(CharStreams.fromString(dottedKey));
        lexer.mode(1);
        TomlParser parser = new TomlParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        AccumulatingErrorListener errorListener = new AccumulatingErrorListener();
        parser.addErrorListener(errorListener);
        List<String> keyList = parser.tomlKey().accept(new KeyVisitor());
        List<TomlParseError> errors = errorListener.errors();
        if (!errors.isEmpty()) {
            TomlParseError e = errors.get(0);
            throw new IllegalArgumentException("Invalid key: " + e.getMessage(), e);
        }
        return keyList;
    }
}

