/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NonExtensible;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.InjectionPointQualifier;
import org.gradle.api.tasks.Nested;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.internal.Cast;
import org.gradle.internal.extensibility.NoConventionMapping;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.reflect.TypeParameter;
import org.gradle.internal.impldep.com.google.common.reflect.TypeToken;
import org.gradle.internal.instantiation.ClassGenerationException;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.ClassInspector;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.internal.reflect.MethodSet;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.PropertyDetails;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final ImmutableSet<Class<?>> MANAGED_PROPERTY_TYPES = ImmutableSet.of(ConfigurableFileCollection.class, ConfigurableFileTree.class, ListProperty.class, SetProperty.class, MapProperty.class, RegularFileProperty.class, new Class[]{DirectoryProperty.class, Property.class, NamedDomainObjectContainer.class, DomainObjectSet.class});
    private static final Object[] NO_PARAMS = new Object[0];
    private final CrossBuildInMemoryCache<Class<?>, GeneratedClassImpl> generatedClasses;
    private final ImmutableSet<Class<? extends Annotation>> disabledAnnotations;
    private final ImmutableSet<Class<? extends Annotation>> enabledAnnotations;
    private final ImmutableMultimap<Class<? extends Annotation>, TypeToken<?>> allowedTypesForAnnotation;
    private final Function<Class<?>, GeneratedClassImpl> generator = this::generateUnderLock;
    private final PropertyRoleAnnotationHandler roleHandler;

    protected AbstractClassGenerator(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledAnnotations, PropertyRoleAnnotationHandler roleHandler, CrossBuildInMemoryCache<Class<?>, GeneratedClassImpl> generatedClassesCache) {
        this.generatedClasses = generatedClassesCache;
        this.enabledAnnotations = ImmutableSet.copyOf(enabledAnnotations);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableListMultimap.Builder allowedTypesBuilder = ImmutableListMultimap.builder();
        for (InjectAnnotationHandler injectAnnotationHandler : allKnownAnnotations) {
            Class<? extends Annotation> annotationType = injectAnnotationHandler.getAnnotationType();
            if (!enabledAnnotations.contains(annotationType)) {
                builder.add(annotationType);
                continue;
            }
            InjectionPointQualifier injectionPointQualifier = annotationType.getAnnotation(InjectionPointQualifier.class);
            if (injectionPointQualifier == null) continue;
            for (Class<?> supportedType : injectionPointQualifier.supportedTypes()) {
                allowedTypesBuilder.put(annotationType, TypeToken.of(supportedType));
            }
            for (Class<?> supportedProviderType : injectionPointQualifier.supportedProviderTypes()) {
                allowedTypesBuilder.put(annotationType, this.providerOf(supportedProviderType));
            }
        }
        this.disabledAnnotations = builder.build();
        this.allowedTypesForAnnotation = allowedTypesBuilder.build();
        this.roleHandler = roleHandler;
    }

    PropertyRoleAnnotationHandler getRoleHandler() {
        return this.roleHandler;
    }

    private <T> TypeToken<Provider<T>> providerOf(Class<T> providerType) {
        return new TypeToken<Provider<T>>(){}.where(new TypeParameter<T>(){}, providerType);
    }

    @Override
    public <T> ClassGenerator.GeneratedClass<? extends T> generate(Class<T> type) {
        GeneratedClassImpl generatedClass = (GeneratedClassImpl)this.generatedClasses.getIfPresent(type);
        if (generatedClass == null) {
            generatedClass = this.generatedClasses.get(type, this.generator);
            this.generatedClasses.put(generatedClass.generatedClass, generatedClass);
        }
        return (ClassGenerator.GeneratedClass)Cast.uncheckedNonnullCast(generatedClass);
    }

    /*
     * WARNING - void declaration
     */
    private GeneratedClassImpl generateUnderLock(Class<?> type) {
        void var14_29;
        Class<?> clazz;
        ArrayList<CustomInjectAnnotationPropertyHandler> customAnnotationPropertyHandlers = new ArrayList<CustomInjectAnnotationPropertyHandler>(this.enabledAnnotations.size());
        ServicesPropertyHandler servicesHandler = new ServicesPropertyHandler();
        InjectAnnotationPropertyHandler injectionHandler = new InjectAnnotationPropertyHandler();
        PropertyTypePropertyHandler propertyTypedHandler = new PropertyTypePropertyHandler();
        ManagedPropertiesHandler managedPropertiesHandler = new ManagedPropertiesHandler();
        ExtensibleTypePropertyHandler extensibleTypeHandler = new ExtensibleTypePropertyHandler();
        DslMixInPropertyType dslMixInHandler = new DslMixInPropertyType(extensibleTypeHandler);
        ArrayList<ClassGenerationHandler> handlers = new ArrayList<ClassGenerationHandler>(5 + this.enabledAnnotations.size() + this.disabledAnnotations.size());
        handlers.add(extensibleTypeHandler);
        handlers.add(dslMixInHandler);
        handlers.add(propertyTypedHandler);
        handlers.add(servicesHandler);
        handlers.add(managedPropertiesHandler);
        for (Class clazz2 : this.enabledAnnotations) {
            customAnnotationPropertyHandlers.add(new CustomInjectAnnotationPropertyHandler(clazz2));
        }
        handlers.addAll(customAnnotationPropertyHandlers);
        handlers.add(injectionHandler);
        ArrayList<ClassValidator> validators = new ArrayList<ClassValidator>(2 + this.disabledAnnotations.size());
        for (Class clazz3 : this.disabledAnnotations) {
            validators.add(new DisabledAnnotationValidator(clazz3));
        }
        validators.add(new InjectionAnnotationValidator(this.enabledAnnotations, this.allowedTypesForAnnotation));
        try {
            ClassInspectionVisitor classInspectionVisitor = this.start(type);
            this.inspectType(type, validators, handlers, extensibleTypeHandler);
            for (ClassGenerationHandler classGenerationHandler : handlers) {
                classGenerationHandler.applyTo(classInspectionVisitor);
            }
            ClassGenerationVisitor generationVisitor = classInspectionVisitor.builder();
            for (ClassGenerationHandler handler : handlers) {
                handler.applyTo(generationVisitor);
            }
            if (type.isInterface()) {
                generationVisitor.addDefaultConstructor();
            } else {
                for (Constructor<?> constructor : type.getConstructors()) {
                    generationVisitor.addConstructor(constructor);
                }
            }
            clazz = generationVisitor.generate();
        }
        catch (ClassGenerationException classGenerationException) {
            throw classGenerationException;
        }
        catch (Throwable throwable) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not generate a decorated class for type ");
            formatter.appendType(type);
            formatter.append(".");
            throw new ClassGenerationException(formatter.toString(), throwable);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (CustomInjectAnnotationPropertyHandler customInjectAnnotationPropertyHandler : customAnnotationPropertyHandlers) {
            if (!customInjectAnnotationPropertyHandler.isUsed()) continue;
            builder.add(customInjectAnnotationPropertyHandler.getAnnotation());
        }
        Class<?> enclosingClass = type.getEnclosingClass();
        if (enclosingClass != null && !Modifier.isStatic(type.getModifiers())) {
            Class<?> clazz4 = enclosingClass;
        } else {
            Object var14_28 = null;
        }
        return new GeneratedClassImpl(clazz, (Class<?>)var14_29, injectionHandler.getInjectedServices(), (List<Class<? extends Annotation>>)((Object)builder.build()));
    }

    protected abstract ClassInspectionVisitor start(Class<?> var1);

    protected abstract InstantiationStrategy createUsingConstructor(Constructor<?> var1);

    protected abstract InstantiationStrategy createForSerialization(Class<?> var1, Class<?> var2);

    /*
     * WARNING - void declaration
     */
    private void inspectType(Class<?> type, List<ClassValidator> validators, List<ClassGenerationHandler> generationHandlers, UnclaimedPropertyHandler unclaimedHandler) {
        ClassDetails classDetails = ClassInspector.inspect(type);
        ClassMetadata classMetaData = new ClassMetadata(type);
        this.assembleProperties(classDetails, classMetaData);
        for (ClassGenerationHandler classGenerationHandler : generationHandlers) {
            classGenerationHandler.startType(type);
        }
        for (Method method : classDetails.getAllMethods()) {
            for (ClassValidator classValidator : validators) {
                classValidator.validateMethod(method, PropertyAccessorType.of(method));
            }
        }
        for (PropertyDetails propertyDetails : classDetails.getProperties()) {
            void var10_20;
            PropertyMetadata propertyMetaData = classMetaData.property(propertyDetails.getName());
            for (ClassGenerationHandler handler : generationHandlers) {
                handler.visitProperty(propertyMetaData);
            }
            Object var10_19 = null;
            for (ClassGenerationHandler handler : generationHandlers) {
                if (!handler.claimPropertyImplementation(propertyMetaData)) continue;
                if (var10_20 == null) {
                    ClassGenerationHandler classGenerationHandler = handler;
                    continue;
                }
                handler.ambiguous(propertyMetaData);
                break;
            }
            if (var10_20 != null) continue;
            unclaimedHandler.unclaimed(propertyMetaData);
            for (Method method : propertyDetails.getGetters()) {
                this.assertNotAbstract(type, method);
            }
            for (Method method : propertyDetails.getSetters()) {
                this.assertNotAbstract(type, method);
            }
            for (Method method : propertyMetaData.setMethods) {
                this.assertNotAbstract(type, method);
            }
        }
        for (Method method : classDetails.getInstanceMethods()) {
            this.assertNotAbstract(type, method);
            for (ClassGenerationHandler classGenerationHandler : generationHandlers) {
                classGenerationHandler.visitInstanceMethod(method);
            }
        }
        this.visitFields(classDetails, generationHandlers);
    }

    private void visitFields(ClassDetails type, List<ClassGenerationHandler> generationHandlers) {
        if (!type.getInstanceFields().isEmpty()) {
            for (ClassGenerationHandler handler : generationHandlers) {
                handler.hasFields();
            }
        }
    }

    private void assembleProperties(ClassDetails classDetails, ClassMetadata classMetaData) {
        for (PropertyDetails propertyDetails : classDetails.getProperties()) {
            PropertyMetadata propertyMetaData = classMetaData.property(propertyDetails.getName());
            for (Method method : propertyDetails.getGetters()) {
                propertyMetaData.addGetter(classMetaData.resolveTypeVariables(method));
            }
            for (Method method : propertyDetails.getSetters()) {
                propertyMetaData.addSetter(method);
            }
            if (propertyDetails.getBackingField() == null) continue;
            propertyMetaData.field(propertyDetails.getBackingField());
        }
        for (Method method : classDetails.getInstanceMethods()) {
            PropertyMetadata propertyMetaData;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || (propertyMetaData = classMetaData.getProperty(method.getName())) == null) continue;
            propertyMetaData.addSetMethod(method);
        }
    }

    private void assertNotAbstract(Class<?> type, Method method) {
        if (Modifier.isAbstract(type.getModifiers()) && Modifier.isAbstract(method.getModifiers())) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Cannot have abstract method ");
            formatter.appendMethod(method);
            formatter.append(".");
            throw new IllegalArgumentException(formatter.toString());
        }
    }

    private static boolean isManagedProperty(PropertyMetadata property) {
        return property.isReadOnly() && (MANAGED_PROPERTY_TYPES.contains(property.getType()) || property.hasAnnotation(Nested.class));
    }

    private static boolean isEagerAttachProperty(PropertyMetadata property) {
        return property.isReadOnly() && !property.getMainGetter().shouldOverride() && AbstractClassGenerator.isPropertyType(property.getType());
    }

    private static boolean isLazyAttachProperty(PropertyMetadata property) {
        return property.isReadOnly() && !property.getOverridableGetters().isEmpty() && (Provider.class.isAssignableFrom(property.getType()) || property.hasAnnotation(Nested.class));
    }

    private static boolean isPropertyType(Class<?> type) {
        return Property.class.isAssignableFrom(type) || HasMultipleValues.class.isAssignableFrom(type) || MapProperty.class.isAssignableFrom(type);
    }

    private static boolean isAttachableType(MethodMetadata method) {
        return Provider.class.isAssignableFrom(method.getReturnType()) || method.method.getAnnotation(Nested.class) != null;
    }

    private boolean isRoleType(PropertyMetadata property) {
        for (Class<? extends Annotation> roleAnnotation : this.roleHandler.getAnnotationTypes()) {
            if (!property.hasAnnotation(roleAnnotation)) continue;
            return true;
        }
        return false;
    }

    protected static interface ClassGenerationVisitor {
        public void addConstructor(Constructor<?> var1);

        public void addDefaultConstructor();

        public void mixInDynamicAware();

        public void mixInConventionAware();

        public void mixInGroovyObject();

        public void addDynamicMethods();

        public void addExtensionsProperty();

        public void applyServiceInjectionToProperty(PropertyMetadata var1);

        public void applyServiceInjectionToGetter(PropertyMetadata var1, MethodMetadata var2);

        public void applyServiceInjectionToSetter(PropertyMetadata var1, Method var2);

        public void applyServiceInjectionToGetter(PropertyMetadata var1, Class<? extends Annotation> var2, MethodMetadata var3);

        public void applyServiceInjectionToSetter(PropertyMetadata var1, Class<? extends Annotation> var2, Method var3);

        public void applyManagedStateToProperty(PropertyMetadata var1);

        public void applyManagedStateToGetter(PropertyMetadata var1, Method var2);

        public void applyManagedStateToSetter(PropertyMetadata var1, Method var2);

        public void applyReadOnlyManagedStateToGetter(PropertyMetadata var1, Method var2, boolean var3);

        public void addManagedMethods(Iterable<PropertyMetadata> var1, Iterable<PropertyMetadata> var2);

        public void applyConventionMappingToProperty(PropertyMetadata var1);

        public void applyConventionMappingToGetter(PropertyMetadata var1, MethodMetadata var2, boolean var3, boolean var4);

        public void applyConventionMappingToSetter(PropertyMetadata var1, Method var2);

        public void applyConventionMappingToSetMethod(PropertyMetadata var1, Method var2);

        public void addSetMethod(PropertyMetadata var1, Method var2);

        public void addActionMethod(Method var1);

        public void addPropertySetterOverloads(PropertyMetadata var1, MethodMetadata var2);

        public Class<?> generate() throws Exception;
    }

    protected static interface InstantiationStrategy {
        public Object newInstance(ServiceLookup var1, InstanceGenerator var2, @Nullable Describable var3, Object[] var4) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }

    protected static interface ClassInspectionVisitor {
        public void mixInExtensible();

        public void mixInConventionAware();

        public void providesOwnDynamicObjectImplementation();

        public void providesOwnServicesImplementation();

        public void providesOwnToString();

        public void mixInFullyManagedState();

        public void mixInServiceInjection();

        public void instantiatesNestedObjects();

        public void attachDuringConstruction(PropertyMetadata var1, boolean var2);

        public ClassGenerationVisitor builder();
    }

    private static class DisabledAnnotationValidator
    implements ClassValidator {
        private final Class<? extends Annotation> annotation;

        public DisabledAnnotationValidator(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public void validateMethod(Method method, PropertyAccessorType accessorType) {
            if (method.getAnnotation(this.annotation) != null) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(this.annotation);
                formatter.append(" annotation on method ");
                formatter.appendMethod(method);
                formatter.append(".");
                throw new IllegalArgumentException(formatter.toString());
            }
        }
    }

    private static class CustomInjectAnnotationPropertyHandler
    extends AbstractInjectedPropertyHandler {
        public CustomInjectAnnotationPropertyHandler(Class<? extends Annotation> injectAnnotation) {
            super(injectAnnotation);
        }

        @Override
        public void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetadata property : this.serviceInjectionProperties) {
                visitor.applyServiceInjectionToProperty(property);
                for (MethodMetadata getter : property.getOverridableGetters()) {
                    visitor.applyServiceInjectionToGetter(property, this.annotation, getter);
                }
                for (Method setter : property.getOverridableSetters()) {
                    visitor.applyServiceInjectionToSetter(property, this.annotation, setter);
                }
            }
        }
    }

    private static class InjectAnnotationPropertyHandler
    extends AbstractInjectedPropertyHandler {
        public InjectAnnotationPropertyHandler() {
            super(Inject.class);
        }

        @Override
        public void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetadata property : this.serviceInjectionProperties) {
                visitor.applyServiceInjectionToProperty(property);
                for (MethodMetadata getter : property.getOverridableGetters()) {
                    visitor.applyServiceInjectionToGetter(property, getter);
                }
                for (Method setter : property.getOverridableSetters()) {
                    visitor.applyServiceInjectionToSetter(property, setter);
                }
            }
        }
    }

    private static abstract class AbstractInjectedPropertyHandler
    extends ClassGenerationHandler {
        final Class<? extends Annotation> annotation;
        final List<PropertyMetadata> serviceInjectionProperties = new ArrayList<PropertyMetadata>();

        public AbstractInjectedPropertyHandler(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean claimPropertyImplementation(PropertyMetadata property) {
            for (MethodMetadata getter : property.getters) {
                if (getter.method.getAnnotation(this.annotation) == null) continue;
                this.serviceInjectionProperties.add(property);
                return true;
            }
            return false;
        }

        @Override
        void ambiguous(PropertyMetadata property) {
            for (MethodMetadata getter : property.getters) {
                if (getter.method.getAnnotation(this.annotation) == null) continue;
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(this.annotation);
                formatter.append(" annotation on method ");
                formatter.appendMethod(getter.method);
                formatter.append(".");
                throw new IllegalArgumentException(formatter.toString());
            }
            super.ambiguous(property);
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (!this.serviceInjectionProperties.isEmpty()) {
                visitor.mixInServiceInjection();
            }
        }

        public List<Class<?>> getInjectedServices() {
            ImmutableList.Builder services = ImmutableList.builderWithExpectedSize(this.serviceInjectionProperties.size());
            for (PropertyMetadata property : this.serviceInjectionProperties) {
                services.add(property.getType());
            }
            return services.build();
        }

        public boolean isUsed() {
            return !this.serviceInjectionProperties.isEmpty();
        }

        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }
    }

    private static class ServicesPropertyHandler
    extends ClassGenerationHandler {
        private boolean hasServicesProperty;

        private ServicesPropertyHandler() {
        }

        @Override
        public boolean claimPropertyImplementation(PropertyMetadata property) {
            if (property.getName().equals("services") && property.isReadable() && ServiceRegistry.class.isAssignableFrom(property.getType())) {
                this.hasServicesProperty = true;
                return true;
            }
            return false;
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (this.hasServicesProperty) {
                visitor.providesOwnServicesImplementation();
            }
        }
    }

    private static class InjectionAnnotationValidator
    implements ClassValidator {
        private final Set<Class<? extends Annotation>> annotationTypes;
        private final ImmutableMultimap<Class<? extends Annotation>, TypeToken<?>> allowedTypesForAnnotation;

        InjectionAnnotationValidator(Set<Class<? extends Annotation>> annotationTypes, ImmutableMultimap<Class<? extends Annotation>, TypeToken<?>> allowedTypesForAnnotation) {
            this.annotationTypes = annotationTypes;
            this.allowedTypesForAnnotation = allowedTypesForAnnotation;
        }

        @Override
        public void validateMethod(Method method, PropertyAccessorType accessorType) {
            ArrayList<Class<? extends Annotation>> matches = new ArrayList<Class<? extends Annotation>>();
            this.validateMethod(method, accessorType, Inject.class, matches);
            for (Class<? extends Annotation> annotationType : this.annotationTypes) {
                this.validateMethod(method, accessorType, annotationType, matches);
            }
            if (matches.size() > 1) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation((Class)matches.get(0));
                formatter.append(" and ");
                formatter.appendAnnotation((Class)matches.get(1));
                formatter.append(" annotations together on method ");
                formatter.appendMethod(method);
                formatter.append(".");
                throw new IllegalArgumentException(formatter.toString());
            }
        }

        private void validateMethod(Method method, PropertyAccessorType accessorType, Class<? extends Annotation> annotationType, List<Class<? extends Annotation>> matches) {
            if (method.getAnnotation(annotationType) == null) {
                return;
            }
            matches.add(annotationType);
            if (Modifier.isStatic(method.getModifiers())) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append(" annotation on method ");
                formatter.appendMethod(method);
                formatter.append(" as it is static.");
                throw new IllegalArgumentException(formatter.toString());
            }
            if (accessorType != PropertyAccessorType.GET_GETTER) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append(" annotation on method ");
                formatter.appendMethod(method);
                formatter.append(" as it is not a property getter.");
                throw new IllegalArgumentException(formatter.toString());
            }
            if (Modifier.isFinal(method.getModifiers())) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append(" annotation on method ");
                formatter.appendMethod(method);
                formatter.append(" as it is final.");
                throw new IllegalArgumentException(formatter.toString());
            }
            if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers())) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append(" annotation on method ");
                formatter.appendMethod(method);
                formatter.append(" as it is not public or protected.");
                throw new IllegalArgumentException(formatter.toString());
            }
            Collection allowedTypes = this.allowedTypesForAnnotation.get(annotationType);
            if (!((AbstractCollection)allowedTypes).isEmpty()) {
                Type returnType = method.getGenericReturnType();
                for (TypeToken allowedType : allowedTypes) {
                    if (!allowedType.isSubtypeOf(returnType)) continue;
                    return;
                }
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append(" annotation on property ");
                formatter.appendMethod(method);
                formatter.append(" of type ");
                formatter.append(TypeToken.of(returnType).toString());
                formatter.append(". Allowed property types: ");
                formatter.append(allowedTypes.stream().map(TypeToken::toString).sorted().collect(Collectors.joining(", ")));
                formatter.append(".");
                throw new IllegalArgumentException(formatter.toString());
            }
        }
    }

    private static class PropertyTypePropertyHandler
    extends ClassGenerationHandler {
        private final List<PropertyMetadata> propertyTyped = new ArrayList<PropertyMetadata>();

        private PropertyTypePropertyHandler() {
        }

        @Override
        void visitProperty(PropertyMetadata property) {
            if (property.isReadable() && AbstractClassGenerator.isPropertyType(property.getType())) {
                this.propertyTyped.add(property);
            }
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetadata property : this.propertyTyped) {
                visitor.addPropertySetterOverloads(property, property.mainGetter);
            }
        }
    }

    private class ManagedPropertiesHandler
    extends ClassGenerationHandler {
        private final List<PropertyMetadata> mutableProperties;
        private final List<PropertyMetadata> readOnlyProperties;
        private final List<PropertyMetadata> eagerAttachProperties;
        private boolean hasFields;

        private ManagedPropertiesHandler() {
            this.mutableProperties = new ArrayList<PropertyMetadata>();
            this.readOnlyProperties = new ArrayList<PropertyMetadata>();
            this.eagerAttachProperties = new ArrayList<PropertyMetadata>();
        }

        @Override
        public void hasFields() {
            this.hasFields = true;
        }

        @Override
        void visitProperty(PropertyMetadata property) {
            if (AbstractClassGenerator.isEagerAttachProperty(property)) {
                this.eagerAttachProperties.add(property);
            }
        }

        @Override
        boolean claimPropertyImplementation(PropertyMetadata property) {
            for (MethodMetadata getter : property.getters) {
                if (!getter.shouldImplement() || getter.isAbstract()) continue;
                return false;
            }
            for (Method setter : property.setters) {
                if (Modifier.isAbstract(setter.getModifiers())) continue;
                return false;
            }
            if (AbstractClassGenerator.isManagedProperty(property)) {
                this.readOnlyProperties.add(property);
                return true;
            }
            if (property.isReadable() && property.isWritable()) {
                this.mutableProperties.add(property);
                return true;
            }
            return false;
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (!this.hasFields) {
                visitor.mixInFullyManagedState();
            }
            if (!this.readOnlyProperties.isEmpty()) {
                visitor.instantiatesNestedObjects();
            }
            for (PropertyMetadata property : this.eagerAttachProperties) {
                boolean applyRole = AbstractClassGenerator.this.isRoleType(property);
                visitor.attachDuringConstruction(property, applyRole);
            }
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetadata property : this.mutableProperties) {
                visitor.applyManagedStateToProperty(property);
                for (MethodMetadata getter : property.getters) {
                    visitor.applyManagedStateToGetter(property, getter.method);
                }
                for (Method setter : property.setters) {
                    visitor.applyManagedStateToSetter(property, setter);
                }
            }
            for (PropertyMetadata property : this.readOnlyProperties) {
                visitor.applyManagedStateToProperty(property);
                boolean applyRole = AbstractClassGenerator.this.isRoleType(property);
                for (MethodMetadata getter : property.getters) {
                    visitor.applyReadOnlyManagedStateToGetter(property, getter.method, applyRole);
                }
            }
            if (!this.hasFields) {
                visitor.addManagedMethods(this.mutableProperties, this.readOnlyProperties);
            }
        }
    }

    private class ExtensibleTypePropertyHandler
    extends ClassGenerationHandler
    implements UnclaimedPropertyHandler {
        private Class<?> type;
        private Class<?> noMappingClass;
        private boolean conventionAware;
        private boolean extensible;
        private boolean hasExtensionAwareImplementation;
        private final List<PropertyMetadata> conventionProperties;

        private ExtensibleTypePropertyHandler() {
            this.conventionProperties = new ArrayList<PropertyMetadata>();
        }

        @Override
        void startType(Class<?> type) {
            this.type = type;
            this.extensible = JavaPropertyReflectionUtil.getAnnotation(type, NonExtensible.class) == null;
            this.noMappingClass = Object.class;
            for (Class<?> c = type; c != null && this.noMappingClass == Object.class; c = c.getSuperclass()) {
                if (c.getAnnotation(NoConventionMapping.class) == null) continue;
                this.noMappingClass = c;
            }
            this.conventionAware = this.extensible && this.noMappingClass != type;
        }

        @Override
        boolean claimPropertyImplementation(PropertyMetadata property) {
            if (this.extensible) {
                if (property.getName().equals("extensions")) {
                    for (MethodMetadata getter : property.getOverridableGetters()) {
                        if (!getter.isAbstract()) continue;
                        return true;
                    }
                    this.hasExtensionAwareImplementation = true;
                    return true;
                }
                if (property.getName().equals("conventionMapping") || property.getName().equals("convention")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void unclaimed(PropertyMetadata property) {
            for (MethodMetadata getter : property.getOverridableGetters()) {
                if (getter.method.getDeclaringClass().isAssignableFrom(this.noMappingClass)) continue;
                this.conventionProperties.add(property);
                break;
            }
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (this.extensible) {
                visitor.mixInExtensible();
            }
            if (this.conventionAware) {
                visitor.mixInConventionAware();
            }
            for (PropertyMetadata property : this.conventionProperties) {
                boolean applyRole = AbstractClassGenerator.isLazyAttachProperty(property) && AbstractClassGenerator.this.isRoleType(property);
                if (!applyRole) continue;
                visitor.instantiatesNestedObjects();
            }
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            if (this.extensible && !this.hasExtensionAwareImplementation) {
                visitor.addExtensionsProperty();
            }
            if (this.conventionAware && !IConventionAware.class.isAssignableFrom(this.type)) {
                visitor.mixInConventionAware();
            }
            for (PropertyMetadata property : this.conventionProperties) {
                visitor.applyConventionMappingToProperty(property);
                boolean attachProperty = AbstractClassGenerator.isLazyAttachProperty(property);
                boolean applyRole = attachProperty && AbstractClassGenerator.this.isRoleType(property);
                for (MethodMetadata getter : property.getOverridableGetters()) {
                    boolean attachOwner = attachProperty && AbstractClassGenerator.isAttachableType(getter);
                    visitor.applyConventionMappingToGetter(property, getter, attachOwner, applyRole);
                }
                for (Method setter : property.getOverridableSetters()) {
                    visitor.applyConventionMappingToSetter(property, setter);
                }
            }
        }
    }

    private static class DslMixInPropertyType
    extends ClassGenerationHandler {
        private final ExtensibleTypePropertyHandler extensibleTypeHandler;
        private boolean providesOwnDynamicObject;
        private boolean needDynamicAware;
        private boolean needGroovyObject;
        private boolean providesOwnToString;
        private final List<PropertyMetadata> mutableProperties = new ArrayList<PropertyMetadata>();
        private final MethodSet actionMethods = new MethodSet();
        private final SetMultimap<String, Method> closureMethods = LinkedHashMultimap.create();

        public DslMixInPropertyType(ExtensibleTypePropertyHandler extensibleTypeHandler) {
            this.extensibleTypeHandler = extensibleTypeHandler;
        }

        @Override
        void startType(Class<?> type) {
            this.needDynamicAware = !DynamicObjectAware.class.isAssignableFrom(type);
            this.needGroovyObject = !GroovyObject.class.isAssignableFrom(type);
        }

        @Override
        void visitProperty(PropertyMetadata property) {
            if (!property.isWritable()) {
                return;
            }
            if (Iterable.class.isAssignableFrom(property.getType())) {
                return;
            }
            this.mutableProperties.add(property);
        }

        @Override
        boolean claimPropertyImplementation(PropertyMetadata property) {
            if (property.getName().equals("asDynamicObject")) {
                this.providesOwnDynamicObject = true;
                return true;
            }
            return false;
        }

        @Override
        public void visitInstanceMethod(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].equals(Action.class)) {
                this.actionMethods.add(method);
            } else if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].equals(Closure.class)) {
                this.closureMethods.put(method.getName(), method);
            } else if (method.getName().equals("toString") && parameterTypes.length == 0 && method.getDeclaringClass() != Object.class) {
                this.providesOwnToString = true;
            }
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (this.providesOwnDynamicObject) {
                visitor.providesOwnDynamicObjectImplementation();
            }
            if (this.providesOwnToString) {
                visitor.providesOwnToString();
            }
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            if (this.needDynamicAware) {
                visitor.mixInDynamicAware();
            }
            if (this.needGroovyObject) {
                visitor.mixInGroovyObject();
            }
            visitor.addDynamicMethods();
            this.addMissingClosureOverloads(visitor);
            this.addSetMethods(visitor);
        }

        private void addSetMethods(ClassGenerationVisitor visitor) {
            for (PropertyMetadata property : this.mutableProperties) {
                if (property.setMethods.isEmpty()) {
                    HashSet appliedTo = new HashSet();
                    for (Method setter : property.setters) {
                        if (!appliedTo.add(setter.getParameterTypes()[0])) continue;
                        visitor.addSetMethod(property, setter);
                    }
                    continue;
                }
                if (!this.extensibleTypeHandler.conventionProperties.contains(property)) continue;
                for (Method setMethod : property.setMethods) {
                    visitor.applyConventionMappingToSetMethod(property, setMethod);
                }
            }
        }

        private void addMissingClosureOverloads(ClassGenerationVisitor visitor) {
            for (Method method : this.actionMethods) {
                Method overload = this.findClosureOverload(method, this.closureMethods.get(method.getName()));
                if (overload != null) continue;
                visitor.addActionMethod(method);
            }
        }

        @Nullable
        private Method findClosureOverload(Method method, Collection<Method> candidates) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (Method candidate : candidates) {
                Class<?>[] candidateParameterTypes = candidate.getParameterTypes();
                if (candidateParameterTypes.length != methodParameterTypes.length) continue;
                boolean matches = true;
                for (int i = 0; i < candidateParameterTypes.length - 1; ++i) {
                    if (candidateParameterTypes[i].equals(methodParameterTypes[i])) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return candidate;
            }
            return null;
        }
    }

    private static interface UnclaimedPropertyHandler {
        public void unclaimed(PropertyMetadata var1);
    }

    private static class ClassGenerationHandler {
        private ClassGenerationHandler() {
        }

        void startType(Class<?> type) {
        }

        void visitInstanceMethod(Method method) {
        }

        void visitProperty(PropertyMetadata property) {
        }

        public void hasFields() {
        }

        boolean claimPropertyImplementation(PropertyMetadata property) {
            return false;
        }

        void ambiguous(PropertyMetadata property) {
            throw new UnsupportedOperationException("Multiple matches for " + property.getName());
        }

        void applyTo(ClassInspectionVisitor visitor) {
        }

        void applyTo(ClassGenerationVisitor visitor) {
        }
    }

    private static interface ClassValidator {
        public void validateMethod(Method var1, PropertyAccessorType var2);
    }

    protected static class PropertyMetadata {
        private final String name;
        private final List<MethodMetadata> getters = new ArrayList<MethodMetadata>();
        private final List<MethodMetadata> overridableGetters = new ArrayList<MethodMetadata>();
        private final List<Method> overridableSetters = new ArrayList<Method>();
        private final List<Method> setters = new ArrayList<Method>();
        private final List<Method> setMethods = new ArrayList<Method>();
        private MethodMetadata mainGetter;
        private Field backingField;

        private PropertyMetadata(String name) {
            this.name = name;
        }

        public String toString() {
            return "[property " + this.name + "]";
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.mainGetter != null && this.setters.isEmpty();
        }

        public boolean isReadable() {
            return this.mainGetter != null;
        }

        public boolean isWritable() {
            return !this.setters.isEmpty();
        }

        public boolean hasAnnotation(Class<? extends Annotation> type) {
            if (this.backingField != null && this.backingField.getAnnotation(type) != null) {
                return true;
            }
            return this.mainGetter.method.getAnnotation(type) != null;
        }

        public MethodMetadata getMainGetter() {
            return this.mainGetter;
        }

        public List<MethodMetadata> getOverridableGetters() {
            return this.overridableGetters;
        }

        public List<Method> getOverridableSetters() {
            return this.overridableSetters;
        }

        public Class<?> getType() {
            if (this.mainGetter != null) {
                return this.mainGetter.getReturnType();
            }
            return this.setters.get(0).getParameterTypes()[0];
        }

        public Type getGenericType() {
            if (this.mainGetter != null) {
                return this.mainGetter.getGenericReturnType();
            }
            return this.setters.get(0).getGenericParameterTypes()[0];
        }

        public void addGetter(MethodMetadata metadata) {
            if (metadata.shouldOverride()) {
                this.overridableGetters.add(metadata);
            }
            this.getters.add(metadata);
            if (this.mainGetter == null) {
                this.mainGetter = metadata;
            } else if (!this.mainGetter.shouldImplement() && metadata.shouldImplement()) {
                this.mainGetter = metadata;
            } else if (this.mainGetter.getReturnType().equals(Boolean.TYPE) && !metadata.getReturnType().equals(Boolean.TYPE)) {
                this.mainGetter = metadata;
            } else if (this.mainGetter.getReturnType().isAssignableFrom(metadata.getReturnType())) {
                this.mainGetter = metadata;
            }
        }

        public void addSetter(Method method) {
            if (method.isBridge()) {
                return;
            }
            this.setters.add(method);
            if (!Modifier.isFinal(method.getModifiers())) {
                this.overridableSetters.add(method);
            }
        }

        public void addSetMethod(Method method) {
            this.setMethods.add(method);
        }

        public void field(Field backingField) {
            this.backingField = backingField;
        }
    }

    protected static class MethodMetadata {
        private final Method method;
        private final Type returnType;

        public MethodMetadata(Method method, Type returnType) {
            this.method = method;
            this.returnType = returnType;
        }

        public String getName() {
            return this.method.getName();
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.method.getModifiers());
        }

        boolean shouldOverride() {
            return !Modifier.isFinal(this.method.getModifiers()) && !this.method.isBridge();
        }

        boolean shouldImplement() {
            return !this.method.isBridge();
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        public Type getGenericReturnType() {
            return this.returnType;
        }
    }

    private static class ClassMetadata {
        private final Class<?> type;
        private final Map<String, PropertyMetadata> properties = new LinkedHashMap<String, PropertyMetadata>();

        public ClassMetadata(Class<?> type) {
            this.type = type;
        }

        public MethodMetadata resolveTypeVariables(Method method) {
            Type resolvedReturnType = JavaPropertyReflectionUtil.resolveMethodReturnType(this.type, method);
            return new MethodMetadata(method, resolvedReturnType);
        }

        @Nullable
        public PropertyMetadata getProperty(String name) {
            return this.properties.get(name);
        }

        public PropertyMetadata property(String name) {
            PropertyMetadata property = this.properties.get(name);
            if (property == null) {
                property = new PropertyMetadata(name);
                this.properties.put(name, property);
            }
            return property;
        }
    }

    protected class GeneratedClassImpl
    implements ClassGenerator.GeneratedClass<Object> {
        private final Class<?> generatedClass;
        private final Class<?> outerType;
        private final List<Class<?>> injectedServices;
        private final List<Class<? extends Annotation>> annotationsTriggeringServiceInjection;
        private final List<ClassGenerator.GeneratedConstructor<Object>> constructors;

        public GeneratedClassImpl(@Nullable Class<?> generatedClass, Class<?> outerType, List<Class<?>> injectedServices, List<Class<? extends Annotation>> annotationsTriggeringServiceInjection) {
            this.generatedClass = generatedClass;
            this.outerType = outerType;
            this.injectedServices = injectedServices;
            this.annotationsTriggeringServiceInjection = annotationsTriggeringServiceInjection;
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(generatedClass.getDeclaredConstructors().length);
            for (Constructor<?> constructor : generatedClass.getDeclaredConstructors()) {
                if (constructor.isSynthetic()) continue;
                constructor.setAccessible(true);
                builder.add(new GeneratedConstructorImpl(constructor));
            }
            this.constructors = builder.build();
        }

        @Override
        public Class<Object> getGeneratedClass() {
            return (Class)Cast.uncheckedNonnullCast(this.generatedClass);
        }

        @Override
        @Nullable
        public Class<?> getOuterType() {
            return this.outerType;
        }

        @Override
        public List<ClassGenerator.GeneratedConstructor<Object>> getConstructors() {
            return this.constructors;
        }

        @Override
        public ClassGenerator.SerializationConstructor<Object> getSerializationConstructor(Class<? super Object> baseClass) {
            return new SerializationConstructorImpl(baseClass);
        }

        private class GeneratedConstructorImpl
        implements ClassGenerator.GeneratedConstructor<Object> {
            private final Constructor<?> constructor;
            private final InstantiationStrategy strategy;

            public GeneratedConstructorImpl(Constructor<?> constructor) {
                this.constructor = constructor;
                this.strategy = AbstractClassGenerator.this.createUsingConstructor(constructor);
            }

            @Override
            public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                return this.strategy.newInstance(services, nested, displayName, params);
            }

            @Override
            public boolean requiresService(Class<?> serviceType) {
                for (Class<?> parameterType : this.constructor.getParameterTypes()) {
                    if (!parameterType.isAssignableFrom(serviceType)) continue;
                    return true;
                }
                for (Class injectedService : GeneratedClassImpl.this.injectedServices) {
                    if (!injectedService.isAssignableFrom(serviceType)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean serviceInjectionTriggeredByAnnotation(Class<? extends Annotation> serviceAnnotation) {
                return GeneratedClassImpl.this.annotationsTriggeringServiceInjection.contains(serviceAnnotation);
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return this.constructor.getParameterTypes();
            }

            @Override
            public Type[] getGenericParameterTypes() {
                return this.constructor.getGenericParameterTypes();
            }

            @Override
            @Nullable
            public <S extends Annotation> S getAnnotation(Class<S> annotation) {
                return (S)this.constructor.getAnnotation(annotation);
            }

            @Override
            public int getModifiers() {
                return this.constructor.getModifiers();
            }
        }

        private class SerializationConstructorImpl
        implements ClassGenerator.SerializationConstructor<Object> {
            private final InstantiationStrategy strategy;

            public SerializationConstructorImpl(Class<?> baseClass) {
                this.strategy = AbstractClassGenerator.this.createForSerialization(GeneratedClassImpl.this.generatedClass, baseClass);
            }

            @Override
            public Object newInstance(ServiceLookup services, InstanceGenerator nested) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                return this.strategy.newInstance(services, nested, null, NO_PARAMS);
            }
        }
    }
}

