/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.EnumMap;
import org.gradle.api.JavaVersion;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.MetadataProbe;
import org.gradle.internal.jvm.inspection.ProbedSystemProperty;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;

public class DefaultJvmMetadataDetector
implements JvmMetadataDetector {
    private final ExecHandleFactory execHandleFactory;

    public DefaultJvmMetadataDetector(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
    }

    @Override
    public JvmInstallationMetadata getMetadata(File javaHome) {
        if (javaHome == null || !javaHome.exists()) {
            return this.failure(javaHome, "No such directory: " + javaHome);
        }
        if (Jvm.current().getJavaHome().equals(javaHome)) {
            return this.getMetadataFromCurrentJvm(javaHome);
        }
        return this.getMetadataFromInstallation(javaHome);
    }

    private JvmInstallationMetadata getMetadataFromCurrentJvm(File javaHome) {
        EnumMap<ProbedSystemProperty, String> result = new EnumMap<ProbedSystemProperty, String>(ProbedSystemProperty.class);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            result.put(type, System.getProperty(type.getSystemPropertyKey()));
        }
        return this.asMetadata(javaHome, result);
    }

    private JvmInstallationMetadata asMetadata(File javaHome, EnumMap<ProbedSystemProperty, String> metadata) {
        String implementationVersion = metadata.get((Object)ProbedSystemProperty.VERSION);
        if (implementationVersion == null) {
            return this.failure(javaHome, metadata.get((Object)ProbedSystemProperty.Z_ERROR));
        }
        try {
            JavaVersion.toVersion(implementationVersion);
        }
        catch (IllegalArgumentException e) {
            return this.failure(javaHome, "Cannot parse version number: " + implementationVersion);
        }
        String vendor = metadata.get((Object)ProbedSystemProperty.VENDOR);
        String implementationName = metadata.get((Object)ProbedSystemProperty.VM);
        return JvmInstallationMetadata.from(javaHome, implementationVersion, vendor, implementationName);
    }

    private JvmInstallationMetadata getMetadataFromInstallation(File jdkPath) {
        File probe = this.writeProbeClass();
        ExecHandleBuilder exec = this.execHandleFactory.newExec();
        exec.setWorkingDir(probe.getParentFile());
        exec.executable(DefaultJvmMetadataDetector.javaExecutable(jdkPath));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream errorOutput = new ByteArrayOutputStream();
            String mainClassname = Files.getNameWithoutExtension(probe.getName());
            exec.args("-cp", ".", mainClassname);
            exec.setStandardOutput(out);
            exec.setErrorOutput(errorOutput);
            exec.setIgnoreExitValue(true);
            ExecResult result = exec.build().start().waitForFinish();
            int exitValue = result.getExitValue();
            if (exitValue == 0) {
                return this.parseExecOutput(jdkPath, out.toString());
            }
            return this.failure(jdkPath, "Command returned unexpected result code: " + exitValue + "\nError output:\n" + errorOutput);
        }
        catch (ExecException ex) {
            return this.failure(jdkPath, ex);
        }
    }

    private static File javaExecutable(File jdkPath) {
        return new File(new File(jdkPath, "bin"), OperatingSystem.current().getExecutableName("java"));
    }

    private JvmInstallationMetadata parseExecOutput(File jdkPath, String probeResult) {
        String[] split = probeResult.split(System.getProperty("line.separator"));
        if (split.length != ProbedSystemProperty.values().length - 1) {
            String errorMessage = "Unexpected command output: \n" + probeResult;
            return this.failure(jdkPath, errorMessage);
        }
        EnumMap<ProbedSystemProperty, String> result = new EnumMap<ProbedSystemProperty, String>(ProbedSystemProperty.class);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            result.put(type, split[type.ordinal()].trim());
        }
        return this.asMetadata(jdkPath, result);
    }

    private JvmInstallationMetadata failure(File jdkPath, String errorMessage) {
        return JvmInstallationMetadata.failure(jdkPath, errorMessage);
    }

    private JvmInstallationMetadata failure(File jdkPath, Exception cause) {
        return JvmInstallationMetadata.failure(jdkPath, cause.getMessage());
    }

    private File writeProbeClass() {
        File probe = new MetadataProbe().writeClass(Files.createTempDir());
        probe.deleteOnExit();
        return probe;
    }
}

