/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.management;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.initialization.resolve.RulesMode;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.dsl.dependencies.UnknownProjectFinder;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.management.DependencyResolutionManagementInternal;

@NonNullApi
public class DefaultDependencyResolutionManagement
implements DependencyResolutionManagementInternal {
    private static final DisplayName UNKNOWN_CODE = Describables.of("unknown code");
    private static final Logger LOGGER = Logging.getLogger(DependencyResolutionManagement.class);
    private final List<Action<? super ComponentMetadataHandler>> componentMetadataRulesActions = Lists.newArrayList();
    private final Lazy<DependencyResolutionServices> dependencyResolutionServices;
    private final UserCodeApplicationContext context;
    private final ComponentMetadataHandler registar = new ComponentMetadataRulesRegistar();
    private final Property<RepositoriesMode> repositoryMode;
    private final Property<RulesMode> rulesMode;
    private boolean mutable = true;

    public DefaultDependencyResolutionManagement(UserCodeApplicationContext context, DependencyManagementServices dependencyManagementServices, FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, DependencyMetaDataProvider dependencyMetaDataProvider, ObjectFactory objects) {
        this.context = context;
        this.repositoryMode = objects.property(RepositoriesMode.class).convention(RepositoriesMode.PREFER_PROJECT);
        this.rulesMode = objects.property(RulesMode.class).convention(RulesMode.PREFER_PROJECT);
        this.dependencyResolutionServices = Lazy.locking().of(() -> dependencyManagementServices.create(fileResolver, fileCollectionFactory, dependencyMetaDataProvider, DefaultDependencyResolutionManagement.makeUnknownProjectFinder(), RootScriptDomainObjectContext.INSTANCE));
    }

    @Override
    public void repositories(Action<? super RepositoryHandler> repositoryConfiguration) {
        repositoryConfiguration.execute(this.dependencyResolutionServices.get().getResolveRepositoryHandler());
    }

    @Override
    public void components(Action<? super ComponentMetadataHandler> registration) {
        this.assertMutable();
        this.componentMetadataRulesActions.add(registration);
    }

    @Override
    public ComponentMetadataHandler getComponents() {
        return this.registar;
    }

    @Override
    public RepositoryHandler getRepositories() {
        return this.dependencyResolutionServices.get().getResolveRepositoryHandler();
    }

    @Override
    public Property<RepositoriesMode> getRepositoriesMode() {
        return this.repositoryMode;
    }

    @Override
    public Property<RulesMode> getRulesMode() {
        return this.rulesMode;
    }

    @Override
    public DependencyResolutionManagementInternal.RepositoriesModeInternal getConfiguredRepositoriesMode() {
        this.repositoryMode.finalizeValue();
        return DependencyResolutionManagementInternal.RepositoriesModeInternal.of((RepositoriesMode)((Object)this.repositoryMode.get()));
    }

    @Override
    public DependencyResolutionManagementInternal.RulesModeInternal getConfiguredRulesMode() {
        this.rulesMode.finalizeValue();
        return DependencyResolutionManagementInternal.RulesModeInternal.of((RulesMode)((Object)this.rulesMode.get()));
    }

    @Override
    public void configureProject(ProjectInternal project) {
        if (!this.getConfiguredRepositoriesMode().useProjectRepositories()) {
            project.getRepositories().whenObjectAdded(this::repoMutationDisallowedOnProject);
        }
        if (!this.getConfiguredRulesMode().useProjectRules()) {
            ComponentMetadataHandlerInternal components = (ComponentMetadataHandlerInternal)((Object)project.getDependencies().getComponents());
            components.onAddRule(this::ruleMutationDisallowedOnProject);
        }
    }

    @Override
    public void preventFromFurtherMutation() {
        this.mutable = false;
        RepositoryHandler repositoryHandler = this.getRepositories();
        repositoryHandler.whenObjectAdded(this::mutationDisallowed);
        repositoryHandler.whenObjectRemoved(this::mutationDisallowed);
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new InvalidUserCodeException("Mutation of dependency resolution management in settings is only allowed during settings evaluation");
        }
    }

    private void mutationDisallowed(ArtifactRepository artifactRepository) {
        throw new InvalidUserCodeException("Mutation of repositories declared in settings is only allowed during settings evaluation");
    }

    private void repoMutationDisallowedOnProject(ArtifactRepository artifactRepository) {
        DisplayName displayName;
        UserCodeApplicationContext.Application current = this.context.current();
        DisplayName displayName2 = displayName = current == null ? null : current.getDisplayName();
        if (displayName == null) {
            displayName = UNKNOWN_CODE;
        }
        String message2 = "Build was configured to prefer settings repositories over project repositories but repository '" + artifactRepository.getName() + "' was added by " + displayName;
        switch (this.getConfiguredRepositoriesMode()) {
            case FAIL_ON_PROJECT_REPOS: {
                throw new InvalidUserCodeException(message2);
            }
            case PREFER_SETTINGS: {
                LOGGER.warn(message2);
            }
        }
    }

    private void ruleMutationDisallowedOnProject(DisplayName ruleName) {
        DisplayName displayName;
        UserCodeApplicationContext.Application current = this.context.current();
        DisplayName displayName2 = displayName = current == null ? null : current.getDisplayName();
        if (displayName == null) {
            displayName = UNKNOWN_CODE;
        }
        String message2 = "Build was configured to prefer settings component metadata rules over project rules but rule '" + ruleName + "' was added by " + displayName;
        switch (this.getConfiguredRulesMode()) {
            case FAIL_ON_PROJECT_RULES: {
                throw new InvalidUserCodeException(message2);
            }
            case PREFER_SETTINGS: {
                LOGGER.warn(message2);
            }
        }
    }

    private static ProjectFinder makeUnknownProjectFinder() {
        return new UnknownProjectFinder("Project dependencies are not allowed in shared dependency resolution services");
    }

    @Override
    public void applyRules(ComponentMetadataHandler target) {
        for (Action<? super ComponentMetadataHandler> rule : this.componentMetadataRulesActions) {
            rule.execute(target);
        }
    }

    private class ComponentMetadataRulesRegistar
    implements ComponentMetadataHandler {
        private ComponentMetadataRulesRegistar() {
        }

        @Override
        public ComponentMetadataHandler all(Action<? super ComponentMetadataDetails> rule) {
            DefaultDependencyResolutionManagement.this.components(h -> h.all(rule));
            return this;
        }

        @Override
        public ComponentMetadataHandler all(Closure<?> rule) {
            DefaultDependencyResolutionManagement.this.components(h -> h.all(rule));
            return this;
        }

        @Override
        public ComponentMetadataHandler all(Object ruleSource) {
            DefaultDependencyResolutionManagement.this.components(h -> h.all(ruleSource));
            return this;
        }

        @Override
        public ComponentMetadataHandler all(Class<? extends ComponentMetadataRule> rule) {
            DefaultDependencyResolutionManagement.this.components(h -> h.all(rule));
            return this;
        }

        @Override
        public ComponentMetadataHandler all(Class<? extends ComponentMetadataRule> rule, Action<? super ActionConfiguration> configureAction) {
            DefaultDependencyResolutionManagement.this.components(h -> h.all(rule, configureAction));
            return this;
        }

        @Override
        public ComponentMetadataHandler withModule(Object id, Action<? super ComponentMetadataDetails> rule) {
            DefaultDependencyResolutionManagement.this.components(h -> h.withModule(id, rule));
            return this;
        }

        @Override
        public ComponentMetadataHandler withModule(Object id, Closure<?> rule) {
            DefaultDependencyResolutionManagement.this.components(h -> h.withModule(id, rule));
            return this;
        }

        @Override
        public ComponentMetadataHandler withModule(Object id, Object ruleSource) {
            DefaultDependencyResolutionManagement.this.components(h -> h.withModule(id, ruleSource));
            return this;
        }

        @Override
        public ComponentMetadataHandler withModule(Object id, Class<? extends ComponentMetadataRule> rule) {
            DefaultDependencyResolutionManagement.this.components(h -> h.withModule(id, rule));
            return this;
        }

        @Override
        public ComponentMetadataHandler withModule(Object id, Class<? extends ComponentMetadataRule> rule, Action<? super ActionConfiguration> configureAction) {
            DefaultDependencyResolutionManagement.this.components(h -> h.withModule(id, rule, configureAction));
            return this;
        }
    }
}

