/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java;

import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.normalization.java.ApiMemberWriterFactory;
import org.gradle.internal.normalization.java.impl.ApiMemberSelector;
import org.gradle.internal.normalization.java.impl.ApiMemberWriter;
import org.gradle.internal.normalization.java.impl.MethodStubbingApiMemberAdapter;

public class ApiClassExtractor {
    private static final Pattern LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final Set<String> exportedPackages;
    private final boolean apiIncludesPackagePrivateMembers;
    private final ApiMemberWriterFactory apiMemberWriterFactory;

    public ApiClassExtractor(Set<String> exportedPackages) {
        this(exportedPackages, classWriter -> new ApiMemberWriter(new MethodStubbingApiMemberAdapter(classWriter)));
    }

    public ApiClassExtractor(Set<String> exportedPackages, ApiMemberWriterFactory apiMemberWriterFactory) {
        this.exportedPackages = exportedPackages.isEmpty() ? null : exportedPackages;
        this.apiIncludesPackagePrivateMembers = exportedPackages.isEmpty();
        this.apiMemberWriterFactory = apiMemberWriterFactory;
    }

    private boolean shouldExtractApiClassFrom(ClassReader originalClassReader) {
        if (!ApiMemberSelector.isCandidateApiMember(originalClassReader.getAccess(), this.apiIncludesPackagePrivateMembers)) {
            return false;
        }
        String originalClassName = originalClassReader.getClassName();
        if (ApiClassExtractor.isLocalClass(originalClassName)) {
            return false;
        }
        return this.exportedPackages == null || this.exportedPackages.contains(ApiClassExtractor.packageNameOf(originalClassName));
    }

    public Optional<byte[]> extractApiClassFrom(ClassReader originalClassReader) {
        if (!this.shouldExtractApiClassFrom(originalClassReader)) {
            return Optional.empty();
        }
        ClassWriter apiClassWriter = new ClassWriter(1);
        ApiMemberSelector visitor = new ApiMemberSelector(originalClassReader.getClassName(), this.apiMemberWriterFactory.makeApiMemberWriter(apiClassWriter), this.apiIncludesPackagePrivateMembers);
        originalClassReader.accept(visitor, 6);
        if (visitor.isPrivateInnerClass()) {
            return Optional.empty();
        }
        return Optional.of(apiClassWriter.toByteArray());
    }

    private static String packageNameOf(String internalClassName) {
        int packageSeparatorIndex = internalClassName.lastIndexOf(47);
        return packageSeparatorIndex > 0 ? internalClassName.substring(0, packageSeparatorIndex).replace('/', '.') : "";
    }

    private static boolean isLocalClass(String className) {
        return LOCAL_CLASS_PATTERN.matcher(className).matches();
    }
}

