/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.operations.trace.SerializedOperation;

class SerializedOperationStart
implements SerializedOperation {
    final long id;
    final Long parentId;
    final String displayName;
    final long startTime;
    final Object details;
    final String detailsClassName;

    SerializedOperationStart(BuildOperationDescriptor descriptor, OperationStartEvent startEvent) {
        this.id = descriptor.getId().getId();
        this.parentId = descriptor.getParentId() == null ? null : Long.valueOf(descriptor.getParentId().getId());
        this.displayName = descriptor.getDisplayName();
        this.startTime = startEvent.getStartTime();
        this.details = BuildOperationTrace.toSerializableModel(descriptor.getDetails());
        this.detailsClassName = this.details == null ? null : descriptor.getDetails().getClass().getName();
    }

    SerializedOperationStart(Map<String, ?> map) {
        this.id = ((Integer)map.get("id")).longValue();
        Integer parentId = (Integer)map.get("parentId");
        this.parentId = parentId == null ? null : Long.valueOf(parentId.longValue());
        this.displayName = (String)map.get("displayName");
        this.startTime = (Long)map.get("startTime");
        this.details = map.get("details");
        this.detailsClassName = (String)map.get("detailsClassName");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder<String, Object> map = ImmutableMap.builder();
        map.put("displayName", this.displayName);
        if (this.details != null) {
            map.put("details", this.details);
            map.put("detailsClassName", this.detailsClassName);
        }
        map.put("id", this.id);
        if (this.parentId != null) {
            map.put("parentId", this.parentId);
        }
        map.put("startTime", this.startTime);
        return map.build();
    }
}

