/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http.ntlm;

import java.io.IOException;
import org.gradle.internal.impldep.jcifs.ntlmssp.Type1Message;
import org.gradle.internal.impldep.jcifs.ntlmssp.Type2Message;
import org.gradle.internal.impldep.jcifs.ntlmssp.Type3Message;
import org.gradle.internal.impldep.jcifs.util.Base64;
import org.gradle.internal.impldep.org.apache.http.auth.AuthScheme;
import org.gradle.internal.impldep.org.apache.http.auth.AuthSchemeProvider;
import org.gradle.internal.impldep.org.apache.http.impl.auth.NTLMEngine;
import org.gradle.internal.impldep.org.apache.http.impl.auth.NTLMEngineException;
import org.gradle.internal.impldep.org.apache.http.impl.auth.NTLMScheme;
import org.gradle.internal.impldep.org.apache.http.protocol.HttpContext;

public class NTLMSchemeFactory
implements AuthSchemeProvider {
    @Override
    public AuthScheme create(HttpContext context) {
        return new NTLMScheme(new JCIFSEngine());
    }

    private static class JCIFSEngine
    implements NTLMEngine {
        private static final int TYPE_1_FLAGS = -1610055676;

        private JCIFSEngine() {
        }

        @Override
        public String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
            Type1Message type1Message = new Type1Message(-1610055676, domain, workstation);
            return Base64.encode(type1Message.toByteArray());
        }

        @Override
        public String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
            Type2Message type2Message;
            try {
                type2Message = new Type2Message(Base64.decode(challenge));
            }
            catch (IOException exception) {
                throw new NTLMEngineException("Invalid NTLM type 2 message", exception);
            }
            int type2Flags = type2Message.getFlags();
            int type3Flags = type2Flags & 0xFFFCFFFF;
            Type3Message type3Message = new Type3Message(type2Message, password, domain, username, workstation, type3Flags);
            return Base64.encode(type3Message.toByteArray());
        }
    }
}

