/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Action;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockRegistry;

public abstract class AbstractResourceLockRegistry<K, T extends ResourceLock>
implements ResourceLockRegistry {
    private final Cache<K, T> resourceLocks = CacheBuilder.newBuilder().weakValues().build();
    private final ConcurrentMap<Long, ThreadLockDetails> threadLocks = new ConcurrentHashMap<Long, ThreadLockDetails>();
    private final ResourceLockCoordinationService coordinationService;

    public AbstractResourceLockRegistry(ResourceLockCoordinationService coordinationService) {
        this.coordinationService = coordinationService;
    }

    protected T getOrRegisterResourceLock(final K key, final ResourceLockProducer<K, T> producer) {
        try {
            return (T)((ResourceLock)this.resourceLocks.get(key, new Callable<T>(){

                @Override
                public T call() {
                    return AbstractResourceLockRegistry.this.createResourceLock(key, producer);
                }
            }));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    protected T createResourceLock(K key, ResourceLockProducer<K, T> producer) {
        return producer.create(key, this.coordinationService, this.getLockAction(), this.getUnlockAction());
    }

    @Override
    public Collection<? extends ResourceLock> getResourceLocksByCurrentThread() {
        return ImmutableList.copyOf(this.detailsForCurrentThread().locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S whileDisallowingLockChanges(Factory<S> action) {
        ThreadLockDetails lockDetails = this.detailsForCurrentThread();
        boolean previous = lockDetails.mayChange;
        lockDetails.mayChange = false;
        try {
            S s = action.create();
            return s;
        }
        finally {
            lockDetails.mayChange = previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S allowUncontrolledAccessToAnyResource(Factory<S> factory) {
        ThreadLockDetails lockDetails = this.detailsForCurrentThread();
        boolean previous = lockDetails.canAccessAnything;
        lockDetails.canAccessAnything = true;
        try {
            S s = factory.create();
            return s;
        }
        finally {
            lockDetails.canAccessAnything = previous;
        }
    }

    @Override
    public boolean hasOpenLocks() {
        for (ResourceLock resourceLock : this.resourceLocks.asMap().values()) {
            if (!resourceLock.isLocked()) continue;
            return true;
        }
        return false;
    }

    private Action<ResourceLock> getLockAction() {
        return new Action<ResourceLock>(){

            @Override
            public void execute(ResourceLock resourceLock) {
                AbstractResourceLockRegistry.this.associateResourceLock(resourceLock);
            }
        };
    }

    private Action<ResourceLock> getUnlockAction() {
        return new Action<ResourceLock>(){

            @Override
            public void execute(ResourceLock resourceLock) {
                AbstractResourceLockRegistry.this.unassociateResourceLock(resourceLock);
            }
        };
    }

    public void associateResourceLock(ResourceLock resourceLock) {
        ThreadLockDetails lockDetails = this.detailsForCurrentThread();
        if (!lockDetails.mayChange) {
            throw new IllegalStateException("This thread may not acquire more locks.");
        }
        lockDetails.locks.add(resourceLock);
    }

    private ThreadLockDetails detailsForCurrentThread() {
        long id = Thread.currentThread().getId();
        ThreadLockDetails lockDetails = (ThreadLockDetails)this.threadLocks.get(id);
        if (lockDetails == null) {
            lockDetails = new ThreadLockDetails();
            this.threadLocks.put(id, lockDetails);
        }
        return lockDetails;
    }

    public void unassociateResourceLock(ResourceLock resourceLock) {
        ThreadLockDetails lockDetails = (ThreadLockDetails)this.threadLocks.get(Thread.currentThread().getId());
        if (!lockDetails.mayChange) {
            throw new IllegalStateException("This thread may not release any locks.");
        }
        lockDetails.locks.remove(resourceLock);
    }

    public boolean mayAttemptToChangeLocks() {
        ThreadLockDetails details = this.detailsForCurrentThread();
        return details.mayChange && !details.canAccessAnything;
    }

    public boolean isAllowedUncontrolledAccessToAnyResource() {
        return this.detailsForCurrentThread().canAccessAnything;
    }

    private static class ThreadLockDetails {
        private boolean mayChange = true;
        private boolean canAccessAnything = false;
        private final List<ResourceLock> locks = new ArrayList<ResourceLock>();

        private ThreadLockDetails() {
        }
    }

    public static interface ResourceLockProducer<K, T extends ResourceLock> {
        public T create(K var1, ResourceLockCoordinationService var2, Action<ResourceLock> var3, Action<ResourceLock> var4);
    }
}

