/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.session;

import java.io.Closeable;
import java.util.function.Function;
import org.gradle.StartParameter;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.session.BuildSessionScopeServices;
import org.gradle.internal.session.CrossBuildSessionState;

public class BuildSessionState
implements Closeable {
    private final GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry;
    private final ServiceRegistry userHomeServices;
    private final ServiceRegistry sessionScopeServices;

    public BuildSessionState(GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry, CrossBuildSessionState crossBuildSessionServices, StartParameter startParameter, BuildRequestMetaData requestMetaData, ClassPath injectedPluginClassPath, BuildCancellationToken buildCancellationToken, BuildClientMetaData buildClientMetaData, BuildEventConsumer buildEventConsumer) {
        this.userHomeScopeServiceRegistry = userHomeScopeServiceRegistry;
        this.userHomeServices = userHomeScopeServiceRegistry.getServicesFor(startParameter.getGradleUserHomeDir());
        this.sessionScopeServices = ServiceRegistryBuilder.builder().displayName("build session services").parent(this.userHomeServices).parent(crossBuildSessionServices.getServices()).provider(new BuildSessionScopeServices(startParameter, requestMetaData, injectedPluginClassPath, buildCancellationToken, buildClientMetaData, buildEventConsumer)).build();
    }

    public ServiceRegistry getServices() {
        return this.sessionScopeServices;
    }

    public <T> T run(Function<BuildSessionContext, T> action) {
        return action.apply(new BuildSessionContext(){

            @Override
            public ServiceRegistry getServices() {
                return BuildSessionState.this.sessionScopeServices;
            }
        });
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.sessionScopeServices, () -> this.userHomeScopeServiceRegistry.release(this.userHomeServices)).stop();
    }
}

