/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicLong;

public interface DirectorySnapshotterStatistics {
    public long getVisitedHierarchyCount();

    public long getVisitedDirectoryCount();

    public long getVisitedFiles();

    public long getFailedFiles();

    public static abstract class CollectingFileVisitor
    implements FileVisitor<Path> {
        protected final Collector collector;

        public CollectingFileVisitor(Collector collector) {
            this.collector = collector;
            collector.recordVisitHierarchy();
        }

        @Override
        public final FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) {
            this.collector.recordVisitDirectory();
            return this.doPreVisitDirectory(dir2, attrs);
        }

        protected abstract FileVisitResult doPreVisitDirectory(Path var1, BasicFileAttributes var2);

        @Override
        public final FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.collector.recordVisitFile();
            return this.doVisitFile(file, attrs);
        }

        protected abstract FileVisitResult doVisitFile(Path var1, BasicFileAttributes var2);

        @Override
        public final FileVisitResult visitFileFailed(Path file, IOException exc) {
            this.collector.recordVisitFileFailed();
            return this.doVisitFileFailed(file, exc);
        }

        protected abstract FileVisitResult doVisitFileFailed(Path var1, IOException var2);

        @Override
        public final FileVisitResult postVisitDirectory(Path dir2, IOException exc) {
            return this.doPostVisitDirectory(dir2, exc);
        }

        protected abstract FileVisitResult doPostVisitDirectory(Path var1, IOException var2);
    }

    public static class Collector {
        private final AtomicLong hierarchyCount = new AtomicLong();
        private final AtomicLong directoryCount = new AtomicLong();
        private final AtomicLong fileCount = new AtomicLong();
        private final AtomicLong failedFileCount = new AtomicLong();

        public void recordVisitHierarchy() {
            this.hierarchyCount.incrementAndGet();
        }

        public void recordVisitDirectory() {
            this.directoryCount.incrementAndGet();
        }

        public void recordVisitFile() {
            this.fileCount.incrementAndGet();
        }

        public void recordVisitFileFailed() {
            this.failedFileCount.incrementAndGet();
        }

        public DirectorySnapshotterStatistics collect() {
            final long hierarchyCount = this.hierarchyCount.getAndSet(0L);
            final long directoryCount = this.directoryCount.getAndSet(0L);
            final long fileCount = this.fileCount.getAndSet(0L);
            final long failedFileCount = this.failedFileCount.getAndSet(0L);
            return new DirectorySnapshotterStatistics(){

                @Override
                public long getVisitedHierarchyCount() {
                    return hierarchyCount;
                }

                @Override
                public long getVisitedDirectoryCount() {
                    return directoryCount;
                }

                @Override
                public long getVisitedFiles() {
                    return fileCount;
                }

                @Override
                public long getFailedFiles() {
                    return failedFileCount;
                }

                public String toString() {
                    return MessageFormat.format("Snapshot {0,number,integer} directory hierarchies (visited {1,number,integer} directories, {2,number,integer} files and {3,number,integer} failed files)", hierarchyCount, directoryCount, fileCount, failedFileCount);
                }
            };
        }
    }
}

