/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.AbstractListSnapshot;
import org.gradle.internal.snapshot.impl.ListValueSnapshot;

public class IsolatedList
extends AbstractListSnapshot<Isolatable<?>>
implements Isolatable<List<Object>> {
    public static final IsolatedList EMPTY = new IsolatedList(ImmutableList.of());

    public IsolatedList(ImmutableList<Isolatable<?>> elements) {
        super(elements);
    }

    @Override
    public ValueSnapshot asSnapshot() {
        if (this.elements.isEmpty()) {
            return ListValueSnapshot.EMPTY;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(this.elements.size());
        for (Isolatable element : this.elements) {
            builder.add(element.asSnapshot());
        }
        return new ListValueSnapshot((ImmutableList<ValueSnapshot>)builder.build());
    }

    @Override
    public List<Object> isolate() {
        ArrayList<Object> list = new ArrayList<Object>(this.elements.size());
        for (Isolatable element : this.elements) {
            list.add(element.isolate());
        }
        return list;
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        return null;
    }
}

