/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.SerializedValueSnapshot;

public class IsolatedSerializedValueSnapshot
extends SerializedValueSnapshot
implements Isolatable<Object> {
    private final Class<?> originalClass;

    public IsolatedSerializedValueSnapshot(@Nullable HashCode implementationHash, byte[] serializedValue, Class<?> originalClass) {
        super(implementationHash, serializedValue);
        this.originalClass = originalClass;
    }

    @Override
    public ValueSnapshot asSnapshot() {
        return new SerializedValueSnapshot(this.getImplementationHash(), this.getValue());
    }

    @Override
    public Object isolate() {
        return this.populateClass(this.originalClass);
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        if (type.isAssignableFrom(this.originalClass)) {
            return type.cast(this.isolate());
        }
        if (type.getName().equals(this.originalClass.getName())) {
            return type.cast(this.populateClass(type));
        }
        return null;
    }

    public Class<?> getOriginalClass() {
        return this.originalClass;
    }
}

