/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.AbstractListSnapshot;

public class ListValueSnapshot
extends AbstractListSnapshot<ValueSnapshot>
implements ValueSnapshot {
    public static final ListValueSnapshot EMPTY = new ListValueSnapshot(ImmutableList.of());

    public ListValueSnapshot(ImmutableList<ValueSnapshot> elements) {
        super(elements);
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        return this.processList(value, snapshotter);
    }

    private ValueSnapshot processList(Object value, ValueSnapshotter snapshotter) {
        int i;
        ValueSnapshot element;
        int pos;
        if (!(value instanceof List)) {
            return snapshotter.snapshot(value);
        }
        List list = (List)value;
        int len = Math.min(this.elements.size(), list.size());
        ValueSnapshot newElement = null;
        for (pos = 0; pos < len && (element = (ValueSnapshot)this.elements.get(pos)) == (newElement = snapshotter.snapshot(list.get(pos), element)); ++pos) {
            newElement = null;
        }
        if (pos == this.elements.size() && pos == list.size()) {
            return this;
        }
        ImmutableList.Builder newElements = ImmutableList.builderWithExpectedSize(list.size());
        for (i = 0; i < pos; ++i) {
            newElements.add((ValueSnapshot)this.elements.get(i));
        }
        if (pos < list.size()) {
            if (newElement != null) {
                newElements.add(newElement);
                ++pos;
            }
            for (i = pos; i < list.size(); ++i) {
                newElements.add(snapshotter.snapshot(list.get(i)));
            }
        }
        return new ListValueSnapshot((ImmutableList<ValueSnapshot>)newElements.build());
    }
}

