/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.file.FileEvents;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.OsxFileEventFunctions;
import org.gradle.internal.watch.WatchingNotSupportedException;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.HierarchicalFileWatcherUpdater;

public class DarwinFileWatcherRegistryFactory
extends AbstractFileWatcherRegistryFactory<OsxFileEventFunctions> {
    public DarwinFileWatcherRegistryFactory(Predicate<String> watchFilter) throws NativeIntegrationUnavailableException {
        super(FileEvents.get(OsxFileEventFunctions.class), watchFilter);
    }

    @Override
    protected FileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> fileEvents) throws InterruptedException {
        return ((OsxFileEventFunctions.WatcherBuilder)((OsxFileEventFunctions)this.fileEventFunctions).newWatcher((BlockingQueue)fileEvents)).withLatency(20L, TimeUnit.MICROSECONDS).start();
    }

    @Override
    protected FileWatcherUpdater createFileWatcherUpdater(FileWatcher watcher, Predicate<String> watchFilter) {
        return new HierarchicalFileWatcherUpdater(watcher, DarwinFileWatcherRegistryFactory::validateLocationToWatch, watchFilter);
    }

    private static void validateLocationToWatch(File location) {
        try {
            String canonicalPath = location.getCanonicalPath();
            String absolutePath = location.getAbsolutePath();
            if (!canonicalPath.equals(absolutePath)) {
                throw new WatchingNotSupportedException(String.format("Unable to watch '%s' since itself or one of its parent is a symbolic link (canonical path: '%s')", absolutePath, canonicalPath));
            }
        }
        catch (IOException e) {
            throw new WatchingNotSupportedException("Unable to watch '%s' since its canonical path can't be resolved: " + e.getMessage(), e);
        }
    }
}

