/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.jvm.internal.DefaultJvmAssembly;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.JvmBinarySpecInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.SourceComponentSpec;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.util.CollectionUtils;

public class DefaultJvmBinarySpec
extends BaseBinarySpec
implements JvmBinarySpecInternal {
    private final DefaultJvmAssembly assembly = new DefaultJvmAssembly(this.getIdentifier().child("assembly"));

    @Override
    public JavaToolChain getToolChain() {
        return this.assembly.getToolChain();
    }

    @Override
    public void setToolChain(JavaToolChain toolChain) {
        this.assembly.setToolChain(toolChain);
    }

    @Override
    public JavaPlatform getTargetPlatform() {
        return this.assembly.getTargetPlatform();
    }

    @Override
    public void setTargetPlatform(JavaPlatform platform) {
        this.assembly.setTargetPlatform(platform);
    }

    @Override
    public File getClassesDir() {
        return CollectionUtils.findSingle(this.assembly.getClassDirectories());
    }

    @Override
    public void setClassesDir(File classesDir) {
        DefaultJvmBinarySpec.replaceSingleDirectory(this.assembly.getClassDirectories(), classesDir);
    }

    @Override
    public File getResourcesDir() {
        return CollectionUtils.findSingle(this.assembly.getResourceDirectories());
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        DefaultJvmBinarySpec.replaceSingleDirectory(this.assembly.getResourceDirectories(), resourcesDir);
    }

    public JvmAssembly getAssembly() {
        return this.assembly;
    }

    public static List<DependencySpec> collectDependencies(BinarySpec binary, @Nullable SourceComponentSpec owner, Collection<DependencySpec> ... specificDependencies) {
        ArrayList<DependencySpec> dependencies = Lists.newArrayList();
        if (specificDependencies != null) {
            for (Collection<DependencySpec> deps : specificDependencies) {
                dependencies.addAll(deps);
            }
        }
        Collection<LanguageSourceSet> binarySources = binary.getSources().values();
        Collection<LanguageSourceSet> sourceSets = owner != null ? Iterables.concat(owner.getSources().values(), binarySources) : binarySources;
        for (LanguageSourceSet sourceSet : sourceSets) {
            if (!(sourceSet instanceof DependentSourceSet)) continue;
            dependencies.addAll(((DependentSourceSet)sourceSet).getDependencies().getDependencies());
        }
        return dependencies;
    }
}

