/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.RepositoriesSupplier;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.AbstractOpaqueFileCollection;
import org.gradle.api.internal.tasks.FailureCollectingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Specs;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class DependencyResolvingClasspath
extends AbstractOpaqueFileCollection {
    private final GlobalDependencyResolutionRules globalRules = GlobalDependencyResolutionRules.NO_OP;
    private final RepositoriesSupplier repositoriesSupplier;
    private final BinarySpecInternal binary;
    private final ArtifactDependencyResolver dependencyResolver;
    private final ResolveContext resolveContext;
    private final AttributesSchemaInternal attributesSchema;
    private final BuildOperationExecutor buildOperationExecutor;
    private final String descriptor;
    private ResolveResult resolveResult;

    public DependencyResolvingClasspath(BinarySpecInternal binarySpec, String descriptor, ArtifactDependencyResolver dependencyResolver, RepositoriesSupplier repositoriesSupplier, ResolveContext resolveContext, AttributesSchemaInternal attributesSchema, BuildOperationExecutor buildOperationExecutor) {
        this.binary = binarySpec;
        this.descriptor = descriptor;
        this.dependencyResolver = dependencyResolver;
        this.repositoriesSupplier = repositoriesSupplier;
        this.resolveContext = resolveContext;
        this.attributesSchema = attributesSchema;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public String getDisplayName() {
        return "Classpath for " + this.descriptor;
    }

    @Override
    protected Set<File> getIntrinsicFiles() {
        this.ensureResolved(true);
        final LinkedHashSet<File> result = new LinkedHashSet<File>();
        ParallelResolveArtifactSet artifacts2 = ParallelResolveArtifactSet.wrap(this.resolveResult.artifactsResults.getArtifacts(), this.buildOperationExecutor);
        artifacts2.visit(new ArtifactVisitor(){

            @Override
            public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
                result.add(artifact.getFile());
            }

            @Override
            public void visitFailure(Throwable failure) {
                throw UncheckedException.throwAsUncheckedException(failure);
            }

            @Override
            public boolean requireArtifactFiles() {
                return true;
            }
        });
        return result;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.ensureResolved(false);
        FailureCollectingTaskDependencyResolveContext collectingContext = new FailureCollectingTaskDependencyResolveContext(context);
        this.resolveResult.artifactsResults.getArtifacts().visitDependencies(collectingContext);
        if (!collectingContext.getFailures().isEmpty()) {
            throw new ResolveException(this.getDisplayName(), collectingContext.getFailures());
        }
    }

    private void ensureResolved(boolean failFast) {
        if (this.resolveResult == null) {
            this.resolveResult = this.resolve();
        }
        if (failFast) {
            this.failOnUnresolvedDependency(this.resolveResult.notFound);
        }
    }

    private ResolveResult resolve() {
        ResolveResult result = new ResolveResult();
        this.dependencyResolver.resolve(this.resolveContext, (List)this.repositoriesSupplier.get(), this.globalRules, Specs.satisfyAll(), result, result, this.attributesSchema, new ArtifactTypeRegistry(){

            @Override
            public ImmutableAttributes mapAttributesFor(File file) {
                return ImmutableAttributes.EMPTY;
            }

            @Override
            public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts2) {
                return attributes;
            }

            @Override
            public void visitArtifactTypes(Consumer<? super ImmutableAttributes> action) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ArtifactTypeContainer create() {
                throw new UnsupportedOperationException();
            }
        }, false);
        return result;
    }

    private void failOnUnresolvedDependency(List<Throwable> notFound) {
        if (!notFound.isEmpty()) {
            throw new LibraryResolveException(String.format("Could not resolve all dependencies for '%s' %s", this.binary.getDisplayName(), this.descriptor), notFound);
        }
    }

    class ResolveResult
    implements DependencyGraphVisitor,
    DependencyArtifactsVisitor {
        public final List<Throwable> notFound = new LinkedList<Throwable>();
        public DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(true, ResolutionStrategy.SortOrder.DEFAULT);
        public SelectedArtifactResults artifactsResults;

        ResolveResult() {
        }

        @Override
        public void start(RootGraphNode root) {
        }

        @Override
        public void visitNode(DependencyGraphNode node) {
            for (DependencyGraphEdge dependencyGraphEdge : node.getOutgoingEdges()) {
                ModuleVersionResolveException failure = dependencyGraphEdge.getFailure();
                if (failure == null) continue;
                this.notFound.add(failure);
            }
            this.artifactsBuilder.visitNode(node);
        }

        @Override
        public void visitSelector(DependencyGraphSelector selector) {
        }

        @Override
        public void visitEdges(DependencyGraphNode node) {
        }

        @Override
        public void finish(DependencyGraphNode root) {
        }

        @Override
        public void startArtifacts(RootGraphNode root) {
        }

        @Override
        public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
            this.artifactsBuilder.visitArtifacts(from, fileDependency, artifactSetId, artifactSet);
        }

        @Override
        public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts2) {
            this.artifactsBuilder.visitArtifacts(from, to, artifactSetId, artifacts2);
        }

        @Override
        public void finishArtifacts() {
            this.artifactsResults = this.artifactsBuilder.complete().select(Specs.satisfyAll(), new VariantSelector(){

                @Override
                public ImmutableAttributes getRequestedAttributes() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ResolvedArtifactSet select(ResolvedVariantSet candidates, VariantSelector.Factory factory) {
                    return candidates.getVariants().iterator().next().getArtifacts();
                }
            });
        }
    }
}

