/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.resolve;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.VariantAspect;

public class DefaultVariantsMetaData
implements VariantsMetaData {
    private final Map<String, Object> variantCoordinates;
    private final Set<String> allVariantAxes;
    private final Set<String> nonNullVariantAxes;
    private final Map<String, ModelType<?>> variantAxisTypes;

    private DefaultVariantsMetaData(Map<String, Object> variantCoordinates, Map<String, ModelType<?>> variantAxisTypes) {
        this.variantCoordinates = variantCoordinates;
        this.allVariantAxes = variantCoordinates.keySet();
        this.nonNullVariantAxes = ImmutableSet.copyOf(Maps.filterEntries(variantCoordinates, new Predicate<Map.Entry<String, Object>>(){

            @Override
            public boolean apply(Map.Entry<String, Object> input) {
                return input.getValue() != null;
            }
        }).keySet());
        this.variantAxisTypes = variantAxisTypes;
    }

    public static VariantsMetaData extractFrom(BinarySpec binarySpec, ModelSchema<?> binarySpecSchema) {
        VariantAspect variantAspect;
        LinkedHashMap<String, ?> variants = Maps.newLinkedHashMap();
        ImmutableMap.Builder<String, ModelType<?>> dimensionTypesBuilder = ImmutableMap.builder();
        if (binarySpecSchema instanceof StructSchema && (variantAspect = ((StructSchema)binarySpecSchema).getAspect(VariantAspect.class)) != null) {
            for (ModelProperty<?> property : variantAspect.getDimensions()) {
                Object value = property.getPropertyValue(binarySpec);
                variants.put(property.getName(), value);
                dimensionTypesBuilder.put(property.getName(), property.getType());
            }
        }
        return new DefaultVariantsMetaData(Collections.unmodifiableMap(variants), dimensionTypesBuilder.build());
    }

    @Override
    public Set<String> getDeclaredVariantAxes() {
        return this.allVariantAxes;
    }

    @Override
    public Set<String> getNonNullVariantAxes() {
        return this.nonNullVariantAxes;
    }

    @Override
    public String getValueAsString(String variantAxis) {
        Object o = this.variantCoordinates.get(variantAxis);
        if (o instanceof Named) {
            return ((Named)o).getName();
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o == null ? null : o.toString();
    }

    @Override
    public <T extends Named> T getValueAsType(Class<T> clazz, String variantAxis) {
        return (T)((Named)this.variantCoordinates.get(variantAxis));
    }

    @Override
    public ModelType<?> getVariantAxisType(String variantAxis) {
        return this.variantAxisTypes.get(variantAxis);
    }
}

