/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.function.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;

public class DefaultJvmVendorSpec
extends JvmVendorSpec
implements Predicate<JavaToolchain> {
    private static final JvmVendorSpec ANY = new DefaultJvmVendorSpec(v -> true, "any");
    private final Predicate<JvmVendor> matcher;
    private final String description;

    public static JvmVendorSpec matching(String match) {
        return new DefaultJvmVendorSpec(vendor -> StringUtils.containsIgnoreCase(vendor.getRawVendor(), match), "matching('" + match + "')");
    }

    public static JvmVendorSpec of(JvmVendor.KnownJvmVendor knownVendor) {
        return new DefaultJvmVendorSpec(vendor -> vendor.getKnownVendor() == knownVendor, knownVendor.toString());
    }

    public static JvmVendorSpec any() {
        return ANY;
    }

    private DefaultJvmVendorSpec(Predicate<JvmVendor> predicate, String description) {
        this.matcher = predicate;
        this.description = description;
    }

    @Override
    public boolean test(JavaToolchain toolchain) {
        JvmVendor vendor = toolchain.getMetadata().getVendor();
        return this.test(vendor);
    }

    @Override
    public boolean test(JvmVendor vendor) {
        return this.matcher.test(vendor);
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJvmVendorSpec that = (DefaultJvmVendorSpec)o;
        return Objects.equal(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hashCode(this.description);
    }
}

