/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.ProjectLayout;
import org.gradle.language.base.internal.model.BinarySourceTransformations;
import org.gradle.language.base.internal.registry.DefaultLanguageTransformContainer;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleInput;
import org.gradle.model.RuleSource;
import org.gradle.model.RuleTarget;
import org.gradle.model.Rules;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.platform.base.ApplicationSpec;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.GeneralComponentSpec;
import org.gradle.platform.base.LibrarySpec;
import org.gradle.platform.base.PlatformAwareComponentSpec;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.SourceComponentSpec;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultPlatformContainer;
import org.gradle.platform.base.internal.DefaultPlatformResolvers;
import org.gradle.platform.base.internal.HasIntermediateOutputsComponentSpec;
import org.gradle.platform.base.internal.PlatformAwareComponentSpecInternal;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.platform.base.internal.dependents.BaseDependentBinariesResolutionStrategy;
import org.gradle.platform.base.internal.dependents.DefaultDependentBinariesResolver;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;
import org.gradle.platform.base.plugins.BinaryBasePlugin;

@Incubating
public class ComponentModelBasePlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        project.getPluginManager().apply(BinaryBasePlugin.class);
    }

    static class PluginRules
    extends RuleSource {
        PluginRules() {
        }

        @ComponentType
        void registerGeneralComponentSpec(TypeBuilder<GeneralComponentSpec> builder) {
            builder.defaultImplementation(BaseComponentSpec.class);
        }

        @ComponentType
        void registerLibrarySpec(TypeBuilder<LibrarySpec> builder) {
            builder.defaultImplementation(BaseComponentSpec.class);
        }

        @ComponentType
        void registerApplicationSpec(TypeBuilder<ApplicationSpec> builder) {
            builder.defaultImplementation(BaseComponentSpec.class);
        }

        @ComponentType
        void registerPlatformAwareComponent(TypeBuilder<PlatformAwareComponentSpec> builder) {
            builder.internalView(PlatformAwareComponentSpecInternal.class);
        }

        @Hidden
        @Model
        LanguageTransformContainer languageTransforms(CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
            return new DefaultLanguageTransformContainer(collectionCallbackActionDecorator);
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, @Path(value="binaries") ModelMap<BinarySpecInternal> binaries, LanguageTransformContainer languageTransforms, ServiceRegistry serviceRegistry) {
            BinarySourceTransformations transformations = new BinarySourceTransformations(tasks, languageTransforms, serviceRegistry);
            for (BinarySpecInternal binary : binaries) {
                if (binary.isLegacyBinary()) continue;
                transformations.createTasksFor(binary);
            }
        }

        @Model
        public ProjectLayout projectLayout(ProjectIdentifier projectIdentifier, @Path(value="buildDir") File buildDir) {
            return new ProjectLayout(projectIdentifier, buildDir);
        }

        @Model
        PlatformContainer platforms(Instantiator instantiator, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
            return instantiator.newInstance(DefaultPlatformContainer.class, instantiator, collectionCallbackActionDecorator);
        }

        @Hidden
        @Model
        PlatformResolvers platformResolver(PlatformContainer platforms) {
            return new DefaultPlatformResolvers(platforms);
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add(PlatformContainer.class, "platforms", platforms);
        }

        @Mutate
        void collectBinaries(BinaryContainer binaries, ComponentSpecContainer componentSpecs) {
            for (VariantComponentSpec componentSpec : componentSpecs.withType(VariantComponentSpec.class)) {
                for (BinarySpecInternal binary : componentSpec.getBinaries().withType(BinarySpecInternal.class).values()) {
                    binaries.put(binary.getProjectScopedName(), binary);
                }
            }
        }

        @Mutate
        void attachBinariesToAssembleLifecycle(@Path(value="tasks.assemble") Task assemble, ComponentSpecContainer components) {
            ArrayList<BinarySpecInternal> notBuildable = Lists.newArrayList();
            boolean hasBuildableBinaries = false;
            for (VariantComponentSpec component : components.withType(VariantComponentSpec.class)) {
                for (BinarySpecInternal binary : component.getBinaries().withType(BinarySpecInternal.class)) {
                    if (binary.isBuildable()) {
                        assemble.dependsOn(binary);
                        hasBuildableBinaries = true;
                        continue;
                    }
                    notBuildable.add(binary);
                }
            }
            if (!hasBuildableBinaries && !notBuildable.isEmpty()) {
                assemble.doFirst(new CheckForNotBuildableBinariesAction(notBuildable));
            }
        }

        @Defaults
        void initializeComponentSourceSets(@Each HasIntermediateOutputsComponentSpec component, LanguageTransformContainer languageTransforms) {
            for (LanguageTransform languageTransform : languageTransforms) {
                if (!component.getIntermediateTypes().contains(languageTransform.getOutputType())) continue;
                component.getSources().create(languageTransform.getLanguageName(), languageTransform.getSourceSetType());
            }
        }

        @Finalize
        void applyFallbackSourceConventions(@Each LanguageSourceSet languageSourceSet, ProjectIdentifier projectIdentifier) {
            if (languageSourceSet.getSource().getSourceDirectories().isEmpty()) {
                File baseDir = projectIdentifier.getProjectDir();
                String defaultSourceDir = Joiner.on(File.separator).skipNulls().join(baseDir.getPath(), "src", Strings.emptyToNull(languageSourceSet.getParentName()), Strings.emptyToNull(languageSourceSet.getName()));
                languageSourceSet.getSource().srcDir(defaultSourceDir);
            }
        }

        @Finalize
        public void defineBinariesCheckTasks(@Each BinarySpecInternal binary, NamedEntityInstantiator<Task> taskInstantiator) {
            if (binary.isLegacyBinary()) {
                return;
            }
            TaskInternal binaryLifecycleTask = taskInstantiator.create(binary.getNamingScheme().getTaskName("check"), DefaultTask.class);
            binaryLifecycleTask.setGroup("verification");
            binaryLifecycleTask.setDescription("Check " + binary);
            binary.setCheckTask(binaryLifecycleTask);
        }

        @Finalize
        void copyBinariesCheckTasksToTaskContainer(TaskContainer tasks, BinaryContainer binaries) {
            for (BinarySpec binary : binaries) {
                Task checkTask = binary.getCheckTask();
                if (checkTask == null) continue;
                ((TaskContainerInternal)tasks).addInternal(checkTask);
            }
        }

        @Defaults
        void addComponentSourcesSetsToProjectSourceSet(@Each SourceComponentSpec component, final ProjectSourceSet projectSourceSet) {
            component.getSources().afterEach(new Action<LanguageSourceSet>(){

                @Override
                public void execute(LanguageSourceSet languageSourceSet) {
                    projectSourceSet.add(languageSourceSet);
                }
            });
        }

        @Rules
        void inputRules(AttachInputs attachInputs, @Each GeneralComponentSpec component) {
            attachInputs.setBinaries(component.getBinaries());
            attachInputs.setSources(component.getSources());
        }

        @Hidden
        @Model
        DependentBinariesResolver dependentBinariesResolver(Instantiator instantiator) {
            return instantiator.newInstance(DefaultDependentBinariesResolver.class, new Object[0]);
        }

        @Defaults
        void registerBaseDependentBinariesResolutionStrategy(DependentBinariesResolver resolver, ServiceRegistry serviceRegistry) {
            resolver.register(new BaseDependentBinariesResolutionStrategy());
        }

        static abstract class AttachInputs
        extends RuleSource {
            AttachInputs() {
            }

            @RuleTarget
            abstract ModelMap<BinarySpec> getBinaries();

            abstract void setBinaries(ModelMap<BinarySpec> var1);

            @RuleInput
            abstract ModelMap<LanguageSourceSet> getSources();

            abstract void setSources(ModelMap<LanguageSourceSet> var1);

            @Mutate
            void initializeBinarySourceSets(ModelMap<BinarySpec> binaries) {
                binaries.withType(BinarySpecInternal.class, new Action<BinarySpecInternal>(){

                    @Override
                    public void execute(BinarySpecInternal binary) {
                        binary.getInputs().addAll(this.getSources().values());
                    }
                });
            }
        }

        private static class CheckForNotBuildableBinariesAction
        implements Action<Task> {
            private final List<BinarySpecInternal> notBuildable;

            public CheckForNotBuildableBinariesAction(List<BinarySpecInternal> notBuildable) {
                this.notBuildable = notBuildable;
            }

            @Override
            public void execute(Task task) {
                Set<? extends Task> taskDependencies = task.getTaskDependencies().getDependencies(task);
                if (taskDependencies.isEmpty()) {
                    TreeFormatter formatter = new TreeFormatter();
                    formatter.node("No buildable binaries found");
                    formatter.startChildren();
                    for (BinarySpecInternal binary : this.notBuildable) {
                        formatter.node(binary.getDisplayName());
                        formatter.startChildren();
                        binary.getBuildAbility().explain(formatter);
                        formatter.endChildren();
                    }
                    formatter.endChildren();
                    throw new GradleException(formatter.toString());
                }
            }
        }
    }
}

