/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.HashUtil;
import org.gradle.nativeplatform.internal.modulemap.GenerateModuleMapFile;
import org.gradle.nativeplatform.internal.modulemap.ModuleMap;

public class NativeDependencyCache
implements Stoppable {
    private final PersistentCache cache;

    public NativeDependencyCache(CacheRepository cacheRepository) {
        this.cache = cacheRepository.cache("native-dep").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
    }

    public File getModuleMapFile(final ModuleMap moduleMap) {
        final String hash = HashUtil.compactStringFor(moduleMap.getHashCode().toByteArray());
        return this.cache.useCache(new Factory<File>(){

            @Override
            public File create() {
                File dir2 = new File(NativeDependencyCache.this.cache.getBaseDir(), "maps/" + hash + "/" + moduleMap.getModuleName());
                File moduleMapFile = new File(dir2, "module.modulemap");
                if (!moduleMapFile.isFile()) {
                    GenerateModuleMapFile.generateFile(moduleMapFile, moduleMap.getModuleName(), moduleMap.getPublicHeaderPaths());
                }
                return moduleMapFile;
            }
        });
    }

    @Override
    public void stop() {
        this.cache.close();
    }
}

