/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileEdge;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;

public class CompilationStateSerializer
implements Serializer<CompilationState> {
    private final Serializer<File> fileSerializer;
    private final Serializer<HashCode> hashSerializer = new HashCodeSerializer();

    public CompilationStateSerializer() {
        this.fileSerializer = new BaseSerializerFactory().getSerializerFor(File.class);
    }

    @Override
    public CompilationState read(Decoder decoder) throws Exception {
        HashMap<Integer, IncludeFileEdge> ids = new HashMap<Integer, IncludeFileEdge>();
        int sourceFileCount = decoder.readSmallInt();
        ImmutableMap.Builder<File, SourceFileState> builder = ImmutableMap.builder();
        for (int i = 0; i < sourceFileCount; ++i) {
            File sourceFile = this.fileSerializer.read(decoder);
            HashCode sourceHashCode = this.hashSerializer.read(decoder);
            boolean isUnresolved = decoder.readBoolean();
            int includeFileCount = decoder.readSmallInt();
            ImmutableSet.Builder includeFileStateBuilder = ImmutableSet.builder();
            for (int j = 0; j < includeFileCount; ++j) {
                int id = decoder.readSmallInt();
                IncludeFileEdge includeFileState = (IncludeFileEdge)ids.get(id);
                if (includeFileState == null) {
                    String includePath = decoder.readString();
                    HashCode includedBy = null;
                    if (decoder.readBoolean()) {
                        includedBy = this.hashSerializer.read(decoder);
                    }
                    HashCode resolvedTo = this.hashSerializer.read(decoder);
                    includeFileState = new IncludeFileEdge(includePath, includedBy, resolvedTo);
                    ids.put(id, includeFileState);
                }
                includeFileStateBuilder.add(includeFileState);
            }
            builder.put(sourceFile, new SourceFileState(sourceHashCode, isUnresolved, (ImmutableSet<IncludeFileEdge>)includeFileStateBuilder.build()));
        }
        return new CompilationState(builder.build());
    }

    @Override
    public void write(Encoder encoder, CompilationState value) throws Exception {
        HashMap<IncludeFileEdge, Integer> ids = new HashMap<IncludeFileEdge, Integer>();
        encoder.writeSmallInt(value.getFileStates().size());
        for (Map.Entry entry : value.getFileStates().entrySet()) {
            SourceFileState sourceFileState = (SourceFileState)entry.getValue();
            this.fileSerializer.write(encoder, (File)entry.getKey());
            this.hashSerializer.write(encoder, sourceFileState.getHash());
            encoder.writeBoolean(sourceFileState.isHasUnresolved());
            encoder.writeSmallInt(sourceFileState.getEdges().size());
            for (IncludeFileEdge includeFileState : sourceFileState.getEdges()) {
                Integer id = (Integer)ids.get(includeFileState);
                if (id == null) {
                    id = ids.size();
                    ids.put(includeFileState, id);
                    encoder.writeSmallInt(id);
                    encoder.writeString(includeFileState.getIncludePath());
                    if (includeFileState.getIncludedBy() == null) {
                        encoder.writeBoolean(false);
                    } else {
                        encoder.writeBoolean(true);
                        this.hashSerializer.write(encoder, includeFileState.getIncludedBy());
                    }
                    this.hashSerializer.write(encoder, includeFileState.getResolvedTo());
                    continue;
                }
                encoder.writeSmallInt(id);
            }
        }
    }
}

