/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.twirl.internal;

import java.io.Serializable;
import java.util.Collection;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.language.twirl.TwirlTemplateFormat;

public class DefaultTwirlTemplateFormat
implements TwirlTemplateFormat,
Serializable {
    private final String extension;
    private final String formatType;
    private final Collection<String> imports;

    public DefaultTwirlTemplateFormat(String extension, String formatType, Collection<String> imports) {
        Preconditions.checkNotNull(extension, "Custom template extension cannot be null.");
        Preconditions.checkArgument(!extension.startsWith("."), "Custom template extension should not start with a dot.");
        Preconditions.checkNotNull(formatType, "Custom template format type cannot be null.");
        this.extension = extension;
        this.formatType = formatType;
        this.imports = imports;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getFormatType() {
        return this.formatType;
    }

    @Override
    public Collection<String> getTemplateImports() {
        return this.imports;
    }

    public String toString() {
        return "DefaultTwirlTemplateFormat{extension='" + this.extension + '\'' + ", formatType='" + this.formatType + '\'' + ", imports=" + this.imports + '}';
    }
}

