/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.server.CompatibleDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonIdleTimeoutExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonRegistryUnavailableExpirationStrategy;
import org.gradle.launcher.daemon.server.NotMostRecentlyUsedDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.expiry.AllDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.expiry.AnyDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.HealthExpirationStrategy;
import org.gradle.launcher.daemon.server.health.LowMemoryDaemonExpirationStrategy;

public class MasterExpirationStrategy
implements DaemonExpirationStrategy {
    private static final int DUPLICATE_DAEMON_GRACE_PERIOD_MS = 10000;
    private final DaemonExpirationStrategy strategy;

    public MasterExpirationStrategy(Daemon daemon, DaemonServerConfiguration params, HealthExpirationStrategy healthExpirationStrategy, ListenerManager listenerManager) {
        ImmutableList.Builder<DaemonExpirationStrategy> strategies = ImmutableList.builder();
        strategies.add((Object)healthExpirationStrategy);
        strategies.add((Object)new AllDaemonExpirationStrategy(ImmutableList.of(new CompatibleDaemonExpirationStrategy(daemon), new DaemonIdleTimeoutExpirationStrategy(daemon, 10000, TimeUnit.MILLISECONDS), new NotMostRecentlyUsedDaemonExpirationStrategy(daemon))));
        strategies.add((Object)new DaemonIdleTimeoutExpirationStrategy(daemon, params.getIdleTimeout(), TimeUnit.MILLISECONDS));
        this.addLowMemoryDaemonExpirationStrategyWhenSupported(daemon, strategies, listenerManager);
        strategies.add((Object)new DaemonRegistryUnavailableExpirationStrategy(daemon));
        this.strategy = new AnyDaemonExpirationStrategy((List<DaemonExpirationStrategy>)((Object)strategies.build()));
    }

    private void addLowMemoryDaemonExpirationStrategyWhenSupported(Daemon daemon, ImmutableList.Builder<DaemonExpirationStrategy> strategies, ListenerManager listenerManager) {
        LowMemoryDaemonExpirationStrategy lowMemoryDaemonExpirationStrategy = new LowMemoryDaemonExpirationStrategy(0.05);
        listenerManager.addListener(lowMemoryDaemonExpirationStrategy);
        strategies.add((Object)new AllDaemonExpirationStrategy(ImmutableList.of(new DaemonIdleTimeoutExpirationStrategy(daemon, 10000, TimeUnit.MILLISECONDS), new NotMostRecentlyUsedDaemonExpirationStrategy(daemon), lowMemoryDaemonExpirationStrategy)));
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        return this.strategy.checkExpiration();
    }
}

