/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusListener;

public class LowMemoryDaemonExpirationStrategy
implements DaemonExpirationStrategy,
OsMemoryStatusListener {
    private ReentrantLock lock = new ReentrantLock();
    private OsMemoryStatus memoryStatus;
    private final double minFreeMemoryPercentage;
    private long memoryThresholdInBytes;
    private static final Logger LOGGER = Logging.getLogger(LowMemoryDaemonExpirationStrategy.class);
    public static final String EXPIRATION_REASON = "to reclaim system memory";
    public static final long MIN_THRESHOLD_BYTES = 0x18000000L;
    public static final long MAX_THRESHOLD_BYTES = 0x40000000L;

    public LowMemoryDaemonExpirationStrategy(double minFreeMemoryPercentage) {
        Preconditions.checkArgument(minFreeMemoryPercentage >= 0.0, "Free memory percentage must be >= 0");
        Preconditions.checkArgument(minFreeMemoryPercentage <= 1.0, "Free memory percentage must be <= 1");
        this.minFreeMemoryPercentage = minFreeMemoryPercentage;
    }

    private long normalizeThreshold(long thresholdIn, long minValue, long maxValue) {
        return Math.min(maxValue, Math.max(minValue, thresholdIn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DaemonExpirationResult checkExpiration() {
        this.lock.lock();
        try {
            if (this.memoryStatus != null) {
                long freeMem = this.memoryStatus.getFreePhysicalMemory();
                if (freeMem < this.memoryThresholdInBytes) {
                    LOGGER.info("after free system memory (" + NumberUtil.formatBytes(freeMem) + ") fell below threshold of " + NumberUtil.formatBytes(this.memoryThresholdInBytes));
                    DaemonExpirationResult daemonExpirationResult = new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON);
                    return daemonExpirationResult;
                }
                if (freeMem < this.memoryThresholdInBytes * 2L) {
                    LOGGER.debug("Nearing low memory threshold - {}", (Object)this.memoryStatus);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }

    @Override
    public void onOsMemoryStatus(OsMemoryStatus newStatus) {
        this.lock.lock();
        try {
            this.memoryStatus = newStatus;
            this.memoryThresholdInBytes = this.normalizeThreshold((long)((double)this.memoryStatus.getTotalPhysicalMemory() * this.minFreeMemoryPercentage), 0x18000000L, 0x40000000L);
        }
        finally {
            this.lock.unlock();
        }
    }
}

