/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.gradle.api.Transformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ExpressionReplacingVisitorSupport;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.model.dsl.internal.inputs.PotentialInputs;
import org.gradle.model.dsl.internal.transform.ClosureBackedRuleFactory;
import org.gradle.model.dsl.internal.transform.InputReference;
import org.gradle.model.dsl.internal.transform.InputReferences;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.dsl.internal.transform.TransformedClosure;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.util.CollectionUtils;

public class RuleVisitor
extends ExpressionReplacingVisitorSupport {
    public static final String INVALID_ARGUMENT_LIST = "argument list must be exactly 1 literal non empty string";
    public static final String SOURCE_URI_TOKEN = "@@sourceuri@@";
    public static final String SOURCE_DESC_TOKEN = "@@sourcedesc@@";
    private static final String AST_NODE_METADATA_INPUTS_KEY = RuleVisitor.class.getName() + ".inputs";
    private static final String AST_NODE_METADATA_LOCATION_KEY = RuleVisitor.class.getName() + ".location";
    private static final String DOLLAR = "$";
    private static final String GET = "get";
    private static final ClassNode POTENTIAL_INPUTS = new ClassNode(PotentialInputs.class);
    private static final ClassNode TRANSFORMED_CLOSURE = new ClassNode(TransformedClosure.class);
    private static final ClassNode INPUT_REFERENCES = new ClassNode(InputReferences.class);
    private static final ClassNode SOURCE_LOCATION = new ClassNode(SourceLocation.class);
    private static final ClassNode RULE_FACTORY = new ClassNode(ClosureBackedRuleFactory.class);
    private static final String INPUTS_FIELD_NAME = "__inputs__";
    private static final String RULE_FACTORY_FIELD_NAME = "__rule_factory__";
    private static final Token ASSIGN = new Token(100, "=", -1, -1);
    private final String scriptSourceDescription;
    private final URI location;
    private final SourceUnit sourceUnit;
    private InputReferences inputs;
    private VariableExpression inputsVariable;
    private int nestingDepth;
    private int counter;

    public RuleVisitor(SourceUnit sourceUnit, String scriptSourceDescription, URI location) {
        this.scriptSourceDescription = scriptSourceDescription;
        this.location = location;
        this.sourceUnit = sourceUnit;
    }

    public static void visitGeneratedClosure(ClassNode node) {
        MethodNode closureCallMethod = AstUtils.getGeneratedClosureImplMethod(node);
        Statement closureCode = closureCallMethod.getCode();
        InputReferences inputs = (InputReferences)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY);
        if (inputs != null) {
            SourceLocation sourceLocation = (SourceLocation)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_LOCATION_KEY);
            node.addInterface(TRANSFORMED_CLOSURE);
            FieldNode inputsField = new FieldNode(INPUTS_FIELD_NAME, 2, POTENTIAL_INPUTS, node, null);
            FieldNode ruleFactoryField = new FieldNode(RULE_FACTORY_FIELD_NAME, 2, RULE_FACTORY, node, null);
            node.addField(inputsField);
            node.addField(ruleFactoryField);
            ArrayList<Object> statements = new ArrayList<Object>();
            statements.add(new ExpressionStatement((Expression)new BinaryExpression((Expression)new FieldExpression(inputsField), ASSIGN, (Expression)new VariableExpression("inputs"))));
            statements.add(new ExpressionStatement((Expression)new BinaryExpression((Expression)new FieldExpression(ruleFactoryField), ASSIGN, (Expression)new VariableExpression("ruleFactory"))));
            node.addMethod(new MethodNode("makeRule", 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(POTENTIAL_INPUTS, "inputs"), new Parameter(RULE_FACTORY, "ruleFactory")}, new ClassNode[0], (Statement)new BlockStatement(statements, new VariableScope())));
            VariableExpression inputsVar = new VariableExpression("inputs", INPUT_REFERENCES);
            VariableScope methodVarScope = new VariableScope();
            methodVarScope.putDeclaredVariable((Variable)inputsVar);
            statements = new ArrayList();
            statements.add(new ExpressionStatement((Expression)new DeclarationExpression(inputsVar, ASSIGN, (Expression)new ConstructorCallExpression(INPUT_REFERENCES, (Expression)new ArgumentListExpression()))));
            for (InputReference inputReference : inputs.getOwnReferences()) {
                statements.add(new ExpressionStatement((Expression)new MethodCallExpression((Expression)inputsVar, "ownReference", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)inputReference.getPath()), (Expression)new ConstantExpression((Object)inputReference.getLineNumber())))));
            }
            for (InputReference inputReference : inputs.getNestedReferences()) {
                statements.add(new ExpressionStatement((Expression)new MethodCallExpression((Expression)inputsVar, "nestedReference", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)inputReference.getPath()), (Expression)new ConstantExpression((Object)inputReference.getLineNumber())))));
            }
            statements.add(new ReturnStatement((Expression)inputsVar));
            node.addMethod(new MethodNode("inputReferences", 1, INPUT_REFERENCES, new Parameter[0], new ClassNode[0], (Statement)new BlockStatement(statements, methodVarScope)));
            statements = new ArrayList();
            statements.add(new ReturnStatement((Expression)new ConstructorCallExpression(SOURCE_LOCATION, (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)SOURCE_URI_TOKEN), new ConstantExpression((Object)SOURCE_DESC_TOKEN), new ConstantExpression((Object)sourceLocation.getExpression()), new ConstantExpression((Object)sourceLocation.getLineNumber()), new ConstantExpression((Object)sourceLocation.getColumnNumber()))))));
            node.addMethod(new MethodNode("sourceLocation", 1, SOURCE_LOCATION, new Parameter[0], new ClassNode[0], (Statement)new BlockStatement(statements, new VariableScope())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitRuleClosure(ClosureExpression expression, Expression invocation, String invocationDisplayName) {
        InputReferences parentInputs = this.inputs;
        VariableExpression parentInputsVariable = this.inputsVariable;
        try {
            DeclarationExpression variableDeclaration;
            this.inputs = new InputReferences();
            this.inputsVariable = new VariableExpression("__rule_inputs_var_" + this.counter++, POTENTIAL_INPUTS);
            this.inputsVariable.setClosureSharedVariable(true);
            super.visitClosureExpression(expression);
            BlockStatement code = (BlockStatement)expression.getCode();
            code.setNodeMetaData((Object)AST_NODE_METADATA_LOCATION_KEY, (Object)new SourceLocation(this.location, this.scriptSourceDescription, invocationDisplayName, invocation.getLineNumber(), invocation.getColumnNumber()));
            code.setNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY, (Object)this.inputs);
            if (parentInputsVariable != null) {
                expression.getVariableScope().putReferencedLocalVariable((Variable)parentInputsVariable);
            }
            code.getVariableScope().putDeclaredVariable((Variable)this.inputsVariable);
            if (parentInputsVariable == null) {
                variableDeclaration = new DeclarationExpression(this.inputsVariable, ASSIGN, (Expression)new VariableExpression(INPUTS_FIELD_NAME));
                code.getStatements().add(0, new ExpressionStatement((Expression)variableDeclaration));
            } else {
                variableDeclaration = new DeclarationExpression(this.inputsVariable, ASSIGN, (Expression)new ElvisOperatorExpression((Expression)new VariableExpression(INPUTS_FIELD_NAME), (Expression)parentInputsVariable));
                code.getStatements().add(0, new ExpressionStatement((Expression)variableDeclaration));
            }
            for (Parameter parameter : expression.getParameters()) {
                if (!parameter.hasInitialExpression()) continue;
                code.getStatements().add(1, new ExpressionStatement((Expression)new BinaryExpression((Expression)new VariableExpression(parameter.getName()), ASSIGN, parameter.getInitialExpression())));
                parameter.setInitialExpression((Expression)ConstantExpression.NULL);
            }
        }
        finally {
            if (parentInputs != null) {
                parentInputs.addNestedReferences(this.inputs);
            }
            this.inputs = parentInputs;
            this.inputsVariable = parentInputsVariable;
        }
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        ++this.nestingDepth;
        try {
            expression.getVariableScope().putReferencedLocalVariable((Variable)this.inputsVariable);
            super.visitClosureExpression(expression);
        }
        finally {
            --this.nestingDepth;
        }
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expr) {
        String modelPath = this.isDollarPathExpression(expr);
        if (modelPath != null) {
            this.inputs.ownReference(modelPath, expr.getLineNumber());
            this.replaceVisitedExpressionWith((Expression)this.inputReferenceExpression(modelPath));
        } else {
            super.visitPropertyExpression(expr);
        }
    }

    private String isDollarPathExpression(PropertyExpression expr) {
        if (expr.isSafe() || expr.isSpreadSafe()) {
            return null;
        }
        if (expr.getObjectExpression() instanceof VariableExpression) {
            VariableExpression objectExpression = (VariableExpression)expr.getObjectExpression();
            if (objectExpression.getName().equals(DOLLAR)) {
                return expr.getPropertyAsString();
            }
            return null;
        }
        if (expr.getObjectExpression() instanceof PropertyExpression) {
            PropertyExpression objectExpression = (PropertyExpression)expr.getObjectExpression();
            String path = this.isDollarPathExpression(objectExpression);
            if (path != null) {
                return path + '.' + expr.getPropertyAsString();
            }
            return null;
        }
        return null;
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement stat) {
        Expression lastArg;
        ArgumentListExpression arguments;
        MethodCallExpression call;
        if (this.nestingDepth == 0 && stat.getExpression() instanceof MethodCallExpression && (call = (MethodCallExpression)stat.getExpression()).isImplicitThis() && call.getArguments() instanceof ArgumentListExpression && !(arguments = (ArgumentListExpression)call.getArguments()).getExpressions().isEmpty() && (lastArg = arguments.getExpression(arguments.getExpressions().size() - 1)) instanceof ClosureExpression) {
            for (int i = 0; i < arguments.getExpressions().size() - 1; ++i) {
                arguments.getExpressions().set(i, this.replaceExpr(arguments.getExpression(i)));
            }
            ClosureExpression closureExpression = (ClosureExpression)lastArg;
            this.visitRuleClosure(closureExpression, (Expression)call, RuleVisitor.displayName(call));
            StaticMethodCallExpression replaced = new StaticMethodCallExpression(RULE_FACTORY, "decorate", (Expression)new ArgumentListExpression((Expression)new VariableExpression(RULE_FACTORY_FIELD_NAME), (Expression)closureExpression));
            arguments.getExpressions().set(arguments.getExpressions().size() - 1, replaced);
            return;
        }
        super.visitExpressionStatement(stat);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        String methodName = call.getMethodAsString();
        if (call.isImplicitThis() && methodName != null && methodName.equals(DOLLAR)) {
            this.visitInputMethod(call);
            return;
        }
        super.visitMethodCallExpression(call);
    }

    private void visitInputMethod(MethodCallExpression call) {
        ConstantExpression argExpression = AstUtils.hasSingleConstantStringArg(call);
        if (argExpression == null) {
            this.error((ASTNode)call, INVALID_ARGUMENT_LIST);
        } else {
            String modelPath = argExpression.getText();
            if (modelPath.isEmpty()) {
                this.error((ASTNode)argExpression, INVALID_ARGUMENT_LIST);
                return;
            }
            try {
                ModelPath.validatePath(modelPath);
            }
            catch (ModelPath.InvalidPathException e) {
                String message2 = "Invalid model path given as rule input." + SystemProperties.getInstance().getLineSeparator() + "  > " + e.getMessage();
                if (e.getCause() != null) {
                    message2 = message2 + SystemProperties.getInstance().getLineSeparator() + "    > " + e.getCause().getMessage();
                }
                this.error((ASTNode)argExpression, message2);
                return;
            }
            this.inputs.ownReference(modelPath, call.getLineNumber());
            this.replaceVisitedExpressionWith((Expression)this.inputReferenceExpression(modelPath));
        }
    }

    private MethodCallExpression inputReferenceExpression(String modelPath) {
        return new MethodCallExpression((Expression)new VariableExpression((Variable)this.inputsVariable), (Expression)new ConstantExpression((Object)GET), (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)modelPath)));
    }

    private void error(ASTNode call, String message2) {
        SyntaxException syntaxException = new SyntaxException(message2, call.getLineNumber(), call.getColumnNumber());
        this.sourceUnit.getErrorCollector().addError(syntaxException, this.sourceUnit);
    }

    public static String displayName(MethodCallExpression expression) {
        StringBuilder builder = new StringBuilder();
        if (!expression.isImplicitThis()) {
            builder.append(expression.getObjectExpression().getText());
            builder.append('.');
        }
        builder.append(expression.getMethodAsString());
        if (expression.getArguments() instanceof ArgumentListExpression) {
            List otherArgs;
            ArgumentListExpression arguments = (ArgumentListExpression)expression.getArguments();
            boolean hasTrailingClosure = !arguments.getExpressions().isEmpty() && arguments.getExpression(arguments.getExpressions().size() - 1) instanceof ClosureExpression;
            List list = otherArgs = hasTrailingClosure ? arguments.getExpressions().subList(0, arguments.getExpressions().size() - 1) : arguments.getExpressions();
            if (!otherArgs.isEmpty() || !hasTrailingClosure) {
                builder.append("(");
                builder.append(Joiner.on(", ").join(CollectionUtils.collect(otherArgs, new Transformer<Object, Expression>(){

                    @Override
                    public Object transform(Expression expression) {
                        return expression.getText();
                    }
                })));
                builder.append(")");
            }
            if (hasTrailingClosure) {
                builder.append(" { ... }");
            }
        } else {
            builder.append("()");
        }
        return builder.toString();
    }
}

