/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;

public class AsmClassGeneratorUtils {
    private static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
    private static final Type CHARACTER_TYPE = Type.getType(Character.class);
    private static final Type BYTE_TYPE = Type.getType(ByteArrayOutputStream.class);
    private static final Type SHORT_TYPE = Type.getType(Short.class);
    private static final Type INTEGER_TYPE = Type.getType(Integer.class);
    private static final Type LONG_TYPE = Type.getType(Long.class);
    private static final Type FLOAT_TYPE = Type.getType(Float.class);
    private static final Type DOUBLE_TYPE = Type.getType(Double.class);
    private static final String RETURN_PRIMITIVE_BOOLEAN = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]);
    private static final String RETURN_CHAR = Type.getMethodDescriptor(Type.CHAR_TYPE, new Type[0]);
    private static final String RETURN_PRIMITIVE_BYTE = Type.getMethodDescriptor(Type.BYTE_TYPE, new Type[0]);
    private static final String RETURN_PRIMITIVE_SHORT = Type.getMethodDescriptor(Type.SHORT_TYPE, new Type[0]);
    private static final String RETURN_INT = Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]);
    private static final String RETURN_PRIMITIVE_LONG = Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0]);
    private static final String RETURN_PRIMITIVE_FLOAT = Type.getMethodDescriptor(Type.FLOAT_TYPE, new Type[0]);
    private static final String RETURN_PRIMITIVE_DOUBLE = Type.getMethodDescriptor(Type.DOUBLE_TYPE, new Type[0]);

    public static void unboxOrCast(MethodVisitor methodVisitor, Type targetType) {
        switch (targetType.getSort()) {
            case 1: {
                methodVisitor.visitTypeInsn(192, BOOLEAN_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, BOOLEAN_TYPE.getInternalName(), "booleanValue", RETURN_PRIMITIVE_BOOLEAN, false);
                return;
            }
            case 2: {
                methodVisitor.visitTypeInsn(192, CHARACTER_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, CHARACTER_TYPE.getInternalName(), "charValue", RETURN_CHAR, false);
                return;
            }
            case 3: {
                methodVisitor.visitTypeInsn(192, BYTE_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, BYTE_TYPE.getInternalName(), "byteValue", RETURN_PRIMITIVE_BYTE, false);
                break;
            }
            case 4: {
                methodVisitor.visitTypeInsn(192, SHORT_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, SHORT_TYPE.getInternalName(), "shortValue", RETURN_PRIMITIVE_SHORT, false);
                break;
            }
            case 5: {
                methodVisitor.visitTypeInsn(192, INTEGER_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, INTEGER_TYPE.getInternalName(), "intValue", RETURN_INT, false);
                return;
            }
            case 7: {
                methodVisitor.visitTypeInsn(192, LONG_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, LONG_TYPE.getInternalName(), "longValue", RETURN_PRIMITIVE_LONG, false);
                return;
            }
            case 6: {
                methodVisitor.visitTypeInsn(192, FLOAT_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, FLOAT_TYPE.getInternalName(), "floatValue", RETURN_PRIMITIVE_FLOAT, false);
                return;
            }
            case 8: {
                methodVisitor.visitTypeInsn(192, DOUBLE_TYPE.getInternalName());
                methodVisitor.visitMethodInsn(182, DOUBLE_TYPE.getInternalName(), "doubleValue", RETURN_PRIMITIVE_DOUBLE, false);
                return;
            }
            default: {
                methodVisitor.visitTypeInsn(192, targetType.getInternalName());
            }
        }
    }

    public static String signature(Constructor<?> constructor) {
        StringBuilder builder = new StringBuilder();
        AsmClassGeneratorUtils.visitFormalTypeParameters(builder, constructor.getTypeParameters());
        AsmClassGeneratorUtils.visitParameters(builder, constructor.getGenericParameterTypes());
        builder.append("V");
        AsmClassGeneratorUtils.visitExceptions(builder, constructor.getGenericExceptionTypes());
        return builder.toString();
    }

    public static String getterSignature(java.lang.reflect.Type returnType) {
        StringBuilder builder = new StringBuilder();
        builder.append("()");
        AsmClassGeneratorUtils.visitType(returnType, builder);
        return builder.toString();
    }

    public static String signature(Method method) {
        StringBuilder builder = new StringBuilder();
        AsmClassGeneratorUtils.visitFormalTypeParameters(builder, method.getTypeParameters());
        AsmClassGeneratorUtils.visitParameters(builder, method.getGenericParameterTypes());
        AsmClassGeneratorUtils.visitType(method.getGenericReturnType(), builder);
        AsmClassGeneratorUtils.visitExceptions(builder, method.getGenericExceptionTypes());
        return builder.toString();
    }

    private static void visitExceptions(StringBuilder builder, java.lang.reflect.Type[] exceptionTypes) {
        for (java.lang.reflect.Type exceptionType : exceptionTypes) {
            builder.append('^');
            AsmClassGeneratorUtils.visitType(exceptionType, builder);
        }
    }

    private static void visitParameters(StringBuilder builder, java.lang.reflect.Type[] parameterTypes) {
        builder.append('(');
        for (java.lang.reflect.Type paramType : parameterTypes) {
            AsmClassGeneratorUtils.visitType(paramType, builder);
        }
        builder.append(")");
    }

    private static void visitFormalTypeParameters(StringBuilder builder, TypeVariable<?>[] typeParameters) {
        if (typeParameters.length > 0) {
            builder.append('<');
            for (TypeVariable<?> typeVariable : typeParameters) {
                builder.append(typeVariable.getName());
                for (java.lang.reflect.Type bound : typeVariable.getBounds()) {
                    builder.append(':');
                    AsmClassGeneratorUtils.visitType(bound, builder);
                }
            }
            builder.append('>');
        }
    }

    private static void visitType(java.lang.reflect.Type type, StringBuilder builder) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            if (cl.isPrimitive()) {
                builder.append(Type.getType(cl).getDescriptor());
            } else if (cl.isArray()) {
                builder.append(cl.getName().replace('.', '/'));
            } else {
                builder.append('L');
                builder.append(cl.getName().replace('.', '/'));
                builder.append(';');
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            AsmClassGeneratorUtils.visitNested(parameterizedType.getRawType(), builder);
            builder.append('<');
            for (java.lang.reflect.Type param : parameterizedType.getActualTypeArguments()) {
                AsmClassGeneratorUtils.visitType(param, builder);
            }
            builder.append(">;");
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    builder.append('*');
                    return;
                }
            } else {
                for (java.lang.reflect.Type upperType : wildcardType.getUpperBounds()) {
                    builder.append('+');
                    AsmClassGeneratorUtils.visitType(upperType, builder);
                }
            }
            for (java.lang.reflect.Type lowerType : wildcardType.getLowerBounds()) {
                builder.append('-');
                AsmClassGeneratorUtils.visitType(lowerType, builder);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            builder.append('T');
            builder.append(typeVar.getName());
            builder.append(';');
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            builder.append('[');
            AsmClassGeneratorUtils.visitType(arrayType.getGenericComponentType(), builder);
        } else {
            throw new IllegalArgumentException(String.format("Cannot generate signature for %s.", type));
        }
    }

    private static void visitNested(java.lang.reflect.Type type, StringBuilder builder) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            if (cl.isPrimitive()) {
                builder.append(Type.getType(cl).getDescriptor());
            } else {
                builder.append('L');
                builder.append(cl.getName().replace('.', '/'));
            }
        } else {
            AsmClassGeneratorUtils.visitType(type, builder);
        }
    }
}

