/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.util.concurrent.UncheckedExecutionException;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSetNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.manage.schema.extract.SpecializedMapNodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

public class DefaultNodeInitializerRegistry
implements NodeInitializerRegistry {
    public static final ModelReference<NodeInitializerRegistry> DEFAULT_REFERENCE = ModelReference.of("nodeInitializerRegistry", NodeInitializerRegistry.class);
    private final LoadingCache<NodeInitializerContext<?>, NodeInitializer> cache = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<NodeInitializerContext<?>, NodeInitializer>(){

        @Override
        public NodeInitializer load(NodeInitializerContext<?> context) throws Exception {
            return DefaultNodeInitializerRegistry.this.extractNodeInitializer(context);
        }
    });
    private final List<NodeInitializerExtractionStrategy> allStrategies;
    private final List<NodeInitializerExtractionStrategy> additionalStrategies;
    private final ModelSchemaStore schemaStore;

    public DefaultNodeInitializerRegistry(ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
        this.schemaStore = schemaStore;
        this.allStrategies = Lists.newArrayList(new ModelSetNodeInitializerExtractionStrategy(), new SpecializedMapNodeInitializerExtractionStrategy(), new ModelMapNodeInitializerExtractionStrategy(), new ScalarCollectionNodeInitializerExtractionStrategy(), new ManagedImplStructNodeInitializerExtractionStrategy(structBindingsStore));
        this.additionalStrategies = Lists.newArrayList();
    }

    private ModelTypeInitializationException canNotConstructTypeException(NodeInitializerContext<?> context) {
        ImmutableSortedSet.Builder constructibleTypes = ImmutableSortedSet.orderedBy(ModelTypes.displayOrder());
        for (NodeInitializerExtractionStrategy extractor : this.additionalStrategies) {
            for (ModelType<?> constructibleType : extractor.supportedTypes()) {
                if (!context.getConstraints().isSatisfiedBy(constructibleType)) continue;
                constructibleTypes.add(constructibleType);
            }
        }
        return new ModelTypeInitializationException(context, this.schemaStore, ScalarTypes.TYPES, constructibleTypes.build());
    }

    @Override
    public NodeInitializer getNodeInitializer(NodeInitializerContext<?> nodeInitializerContext) {
        try {
            return this.cache.get(nodeInitializerContext);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        catch (UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    private <T> NodeInitializer extractNodeInitializer(NodeInitializerContext<T> context) {
        ModelSchema<T> schema = this.schemaStore.getSchema(context.getModelType());
        for (NodeInitializerExtractionStrategy extractor : this.allStrategies) {
            NodeInitializer nodeInitializer = extractor.extractNodeInitializer(schema, context);
            if (nodeInitializer == null) continue;
            return nodeInitializer;
        }
        throw this.canNotConstructTypeException(context);
    }

    @Override
    public void ensureHasInitializer(NodeInitializerContext<?> nodeInitializer) {
        this.getNodeInitializer(nodeInitializer);
    }

    @Override
    public void registerStrategy(NodeInitializerExtractionStrategy strategy) {
        this.allStrategies.add(0, strategy);
        this.additionalStrategies.add(0, strategy);
    }
}

