/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.extract.PrimitiveTypes;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.type.ModelType;

@ThreadSafe
public class UnmanagedModelProjection<M>
extends TypeCompatibilityModelProjectionSupport<M> {
    public static <M> ModelProjection of(ModelType<M> type) {
        return new UnmanagedModelProjection<M>(type);
    }

    public static <M> ModelProjection of(Class<M> type) {
        return UnmanagedModelProjection.of(ModelType.of(type));
    }

    public UnmanagedModelProjection(ModelType<M> type) {
        super(type);
    }

    @Override
    protected ModelView<M> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
        Object instance = Cast.uncheckedCast(modelNode.getPrivateData());
        return InstanceModelView.of(modelNode.getPath(), this.getType(), instance);
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNode) {
        Object instance = this.asImmutable(ModelType.untyped(), modelNode, null).getInstance();
        if (instance == null) {
            if (PrimitiveTypes.isPrimitiveType(this.getType())) {
                if (this.getType().equals(ModelType.of(Character.TYPE))) {
                    return Optional.of("");
                }
                return Optional.of(String.valueOf(PrimitiveTypes.defaultValueOf(this.getType())));
            }
            if (ScalarTypes.isScalarType(this.getType())) {
                return Optional.of("null");
            }
            return Optional.absent();
        }
        if (JavaPropertyReflectionUtil.hasDefaultToString(instance)) {
            return Optional.absent();
        }
        return Optional.of(this.toStringValueDescription(instance));
    }
}

