/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.Named;
import org.gradle.internal.BiAction;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ModelElementProjection;
import org.gradle.model.internal.inspect.ReadonlyImmutableManagedPropertyException;
import org.gradle.model.internal.inspect.UnmanagedPropertyMissingSetterException;
import org.gradle.model.internal.manage.binding.ManagedProperty;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.type.ModelType;

public class StructNodeInitializer<T>
implements NodeInitializer {
    protected final StructBindings<T> bindings;

    public StructNodeInitializer(StructBindings<T> bindings) {
        this.bindings = bindings;
    }

    @Override
    public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
        return ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, DirectNodeInputUsingModelAction.of(subject, descriptor, Arrays.asList(ModelReference.of(ManagedProxyFactory.class), ModelReference.of(TypeConverter.class)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                ManagedProxyFactory proxyFactory = ModelViews.getInstance(modelViews.get(0), ManagedProxyFactory.class);
                TypeConverter typeConverter = ModelViews.getInstance(modelViews, 1, TypeConverter.class);
                for (StructSchema<?> viewSchema : StructNodeInitializer.this.bindings.getDeclaredViewSchemas()) {
                    StructNodeInitializer.this.addProjection(modelNode, viewSchema, proxyFactory, typeConverter);
                }
                modelNode.addProjection(new ModelElementProjection((ModelType<?>)StructNodeInitializer.this.bindings.getPublicSchema().getType()));
            }
        }))).put((Object)ModelActionRole.Create, DirectNodeInputUsingModelAction.of(subject, descriptor, Arrays.asList(ModelReference.of(ModelSchemaStore.class), ModelReference.of(NodeInitializerRegistry.class)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                ModelSchemaStore schemaStore = ModelViews.getInstance(modelViews, 0, ModelSchemaStore.class);
                NodeInitializerRegistry nodeInitializerRegistry = ModelViews.getInstance(modelViews, 1, NodeInitializerRegistry.class);
                StructNodeInitializer.this.addPropertyLinks(modelNode, schemaStore, nodeInitializerRegistry);
                StructNodeInitializer.this.initializePrivateData(modelNode);
            }
        }))).build();
    }

    protected void initializePrivateData(MutableModelNode modelNode) {
    }

    private <V> void addProjection(MutableModelNode modelNode, StructSchema<V> viewSchema, ManagedProxyFactory proxyFactory, TypeConverter typeConverter) {
        modelNode.addProjection(new ManagedModelProjection<V>(viewSchema, this.bindings, proxyFactory, typeConverter));
    }

    private void addPropertyLinks(MutableModelNode modelNode, ModelSchemaStore schemaStore, NodeInitializerRegistry nodeInitializerRegistry) {
        for (ManagedProperty<?> property : this.bindings.getManagedProperties().values()) {
            this.addPropertyLink(modelNode, property, schemaStore, nodeInitializerRegistry);
        }
        if (this.isNamedType() && this.bindings.getManagedProperties().containsKey("name")) {
            MutableModelNode nameLink = modelNode.getLink("name");
            if (nameLink == null) {
                throw new IllegalStateException("expected name node for " + modelNode.getPath());
            }
            nameLink.setPrivateData(ModelType.of(String.class), modelNode.getPath().getName());
        }
    }

    private <P> void addPropertyLink(MutableModelNode modelNode, ManagedProperty<P> property, ModelSchemaStore schemaStore, NodeInitializerRegistry nodeInitializerRegistry) {
        ModelType<P> propertyType = property.getType();
        ModelSchema<P> propertySchema = schemaStore.getSchema(propertyType);
        ModelType publicType = this.bindings.getPublicSchema().getType();
        this.validateProperty(propertySchema, property, nodeInitializerRegistry);
        ModelPath childPath = modelNode.getPath().child(property.getName());
        if (propertySchema instanceof ManagedImplSchema) {
            if (!property.isWritable() || propertySchema instanceof ScalarCollectionSchema) {
                ModelRegistrations.Builder builder = StructNodeInitializer.managedRegistrationBuilder(childPath, property, nodeInitializerRegistry, publicType);
                this.addLink(modelNode, builder, property.isInternal());
            } else {
                modelNode.addReference(property.getName(), propertyType, null, modelNode.getDescriptor());
            }
        } else {
            ModelRegistrations.Builder registrationBuilder = this.shouldHaveANodeInitializer(property, propertySchema) ? StructNodeInitializer.managedRegistrationBuilder(childPath, property, nodeInitializerRegistry, publicType) : ModelRegistrations.of(childPath);
            registrationBuilder.withProjection(new UnmanagedModelProjection<P>(propertyType));
            registrationBuilder.withProjection(new ModelElementProjection(propertyType));
            this.addLink(modelNode, registrationBuilder, property.isInternal());
        }
    }

    private static <P> ModelRegistrations.Builder managedRegistrationBuilder(ModelPath childPath, ManagedProperty<P> property, NodeInitializerRegistry nodeInitializerRegistry, ModelType<?> publicType) {
        return ModelRegistrations.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(property.getType(), property, publicType)));
    }

    private void addLink(MutableModelNode modelNode, ModelRegistrations.Builder builder, boolean internal) {
        ModelRegistration registration = builder.descriptor(modelNode.getDescriptor()).hidden(internal).build();
        modelNode.addLink(registration);
    }

    private <P> void validateProperty(ModelSchema<P> propertySchema, ManagedProperty<P> property, NodeInitializerRegistry nodeInitializerRegistry) {
        if (propertySchema instanceof ManagedImplSchema) {
            if (!property.isWritable()) {
                if (this.isCollectionOfManagedTypes(propertySchema)) {
                    CollectionSchema propertyCollectionsSchema = (CollectionSchema)propertySchema;
                    ModelType elementType = propertyCollectionsSchema.getElementType();
                    nodeInitializerRegistry.ensureHasInitializer(NodeInitializerContext.forProperty(elementType, property, this.bindings.getPublicSchema().getType()));
                }
                if (property.isDeclaredAsHavingUnmanagedType()) {
                    throw new UnmanagedPropertyMissingSetterException(property.getName());
                }
            }
        } else if (!(this.shouldHaveANodeInitializer(property, propertySchema) || property.isWritable() || this.isNamePropertyOfANamedType(property))) {
            throw new ReadonlyImmutableManagedPropertyException(this.bindings.getPublicSchema().getType(), property.getName(), property.getType());
        }
    }

    private <P> boolean isCollectionOfManagedTypes(ModelSchema<P> propertySchema) {
        return propertySchema instanceof CollectionSchema && !(propertySchema instanceof ScalarCollectionSchema);
    }

    private <P> boolean isNamePropertyOfANamedType(ManagedProperty<P> property) {
        return this.isNamedType() && "name".equals(property.getName());
    }

    private boolean isNamedType() {
        return Named.class.isAssignableFrom(this.bindings.getPublicSchema().getType().getRawClass());
    }

    private <P> boolean shouldHaveANodeInitializer(ManagedProperty<P> property, ModelSchema<P> propertySchema) {
        return !(propertySchema instanceof ScalarValueSchema) && !property.isDeclaredAsHavingUnmanagedType();
    }
}

