/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.cache;

import java.lang.ref.WeakReference;
import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.model.internal.manage.schema.cache.WeakClassSet;

class MultiWeakClassSet
extends WeakClassSet {
    private static final Function<Class<?>, WeakReference<Class<?>>> TO_WEAK_REF = new Function<Class<?>, WeakReference<Class<?>>>(){

        @Override
        public WeakReference<Class<?>> apply(Class<?> input) {
            return new WeakReference(input);
        }
    };
    private static final Function<WeakReference<Class<?>>, Object> UNPACK_REF = new Function<WeakReference<Class<?>>, Object>(){

        @Override
        public Object apply(WeakReference<Class<?>> input) {
            return input.get();
        }
    };
    private final List<WeakReference<Class<?>>> references;
    private final int hash;

    MultiWeakClassSet(List<Class<?>> classes) {
        this.references = Lists.newArrayList(Iterables.transform(classes, TO_WEAK_REF));
        this.hash = classes.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiWeakClassSet) {
            MultiWeakClassSet other = (MultiWeakClassSet)Cast.uncheckedCast(obj);
            if (other.references.size() == this.references.size()) {
                return Iterables.elementsEqual(Iterables.transform(other.references, UNPACK_REF), Iterables.transform(this.references, UNPACK_REF));
            }
        }
        return false;
    }

    @Override
    boolean isCollected() {
        for (WeakReference<Class<?>> reference : this.references) {
            if (reference.get() != null) continue;
            return true;
        }
        return false;
    }
}

