/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.DefaultModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.EnumStrategy;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.JavaUtilCollectionStrategy;
import org.gradle.model.internal.manage.schema.extract.JdkValueTypeStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSetStrategy;
import org.gradle.model.internal.manage.schema.extract.PrimitiveStrategy;
import org.gradle.model.internal.manage.schema.extract.RuleSourceSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.SpecializedMapStrategy;
import org.gradle.model.internal.manage.schema.extract.UnmanagedImplStructStrategy;
import org.gradle.model.internal.type.ModelType;

public class DefaultModelSchemaExtractor
implements ModelSchemaExtractor {
    private final List<? extends ModelSchemaExtractionStrategy> strategies;

    public static DefaultModelSchemaExtractor withDefaultStrategies(List<? extends ModelSchemaExtractionStrategy> strategies, ModelSchemaAspectExtractor aspectExtractor) {
        return new DefaultModelSchemaExtractor((List<? extends ModelSchemaExtractionStrategy>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(strategies)).add(new PrimitiveStrategy())).add(new EnumStrategy())).add(new JdkValueTypeStrategy())).add(new ModelSetStrategy())).add(new SpecializedMapStrategy())).add(new ModelMapStrategy())).add(new JavaUtilCollectionStrategy())).add(new ManagedImplStructStrategy(aspectExtractor))).add(new RuleSourceSchemaExtractionStrategy(aspectExtractor))).add(new UnmanagedImplStructStrategy(aspectExtractor))).build()));
    }

    public static DefaultModelSchemaExtractor withDefaultStrategies() {
        return DefaultModelSchemaExtractor.withDefaultStrategies(Collections.emptyList(), new ModelSchemaAspectExtractor());
    }

    public DefaultModelSchemaExtractor(List<? extends ModelSchemaExtractionStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public <T> ModelSchema<T> extract(ModelType<T> type, ModelSchemaCache cache2) {
        DefaultModelSchemaExtractionContext context = DefaultModelSchemaExtractionContext.root(type);
        ArrayList<DefaultModelSchemaExtractionContext> validations = Lists.newArrayList();
        ArrayDeque unsatisfiedDependencies = new ArrayDeque();
        DefaultModelSchemaExtractionContext extractionContext = context;
        validations.add(extractionContext);
        while (extractionContext != null) {
            this.extractSchema(extractionContext, cache2);
            List<DefaultModelSchemaExtractionContext<?>> dependencies = extractionContext.getChildren();
            Iterables.addAll(validations, dependencies);
            this.pushUnsatisfiedDependencies(dependencies, unsatisfiedDependencies, cache2);
            extractionContext = (DefaultModelSchemaExtractionContext)unsatisfiedDependencies.poll();
        }
        for (DefaultModelSchemaExtractionContext validationContext : Lists.reverse(validations)) {
            this.validate(validationContext, cache2);
        }
        return context.getResult();
    }

    private void pushUnsatisfiedDependencies(Iterable<? extends DefaultModelSchemaExtractionContext<?>> allDependencies, Queue<DefaultModelSchemaExtractionContext<?>> dependencyQueue, final ModelSchemaCache cache2) {
        Iterables.addAll(dependencyQueue, Iterables.filter(allDependencies, new Predicate<ModelSchemaExtractionContext<?>>(){

            @Override
            public boolean apply(ModelSchemaExtractionContext<?> dependency) {
                return cache2.get(dependency.getType()) == null;
            }
        }));
    }

    private <T> void validate(DefaultModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache2) {
        extractionContext.validate(cache2.get(extractionContext.getType()));
    }

    private <T> void extractSchema(DefaultModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache2) {
        ModelType<T> type = extractionContext.getType();
        ModelSchema<T> cached = cache2.get(type);
        if (cached != null) {
            extractionContext.found(cached);
            return;
        }
        for (ModelSchemaExtractionStrategy modelSchemaExtractionStrategy : this.strategies) {
            modelSchemaExtractionStrategy.extract(extractionContext);
            if (extractionContext.hasProblems()) {
                throw new InvalidManagedModelElementTypeException(extractionContext);
            }
            if (extractionContext.getResult() == null) continue;
            cache2.set(type, extractionContext.getResult());
            return;
        }
        throw new IllegalStateException("No extraction strategy found for type: " + type);
    }
}

