/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report.unbound;

import java.io.File;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.report.unbound.UnboundRuleInput;

@ThreadSafe
public class UnboundRule {
    private final String descriptor;
    private final ImmutableList<UnboundRuleInput> immutableInputs;
    private final ImmutableList<UnboundRuleInput> mutableInputs;

    private UnboundRule(String descriptor, ImmutableList<UnboundRuleInput> immutableInputs, ImmutableList<UnboundRuleInput> mutableInputs) {
        this.descriptor = descriptor;
        this.immutableInputs = immutableInputs;
        this.mutableInputs = mutableInputs;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public List<? extends UnboundRuleInput> getImmutableInputs() {
        return this.immutableInputs;
    }

    public List<? extends UnboundRuleInput> getMutableInputs() {
        return this.mutableInputs;
    }

    public static Builder descriptor(String descriptor) {
        return new Builder(descriptor);
    }

    public static Builder descriptor(String descriptor, File location, int line, int column) {
        return new Builder(String.format("%s @ build file '%s' line %d, column %d", descriptor, location.getAbsolutePath(), line, column));
    }

    @NotThreadSafe
    public static class Builder {
        private String descriptor;
        private final ImmutableList.Builder<UnboundRuleInput> immutableInputs = ImmutableList.builder();
        private final ImmutableList.Builder<UnboundRuleInput> mutableInputs = ImmutableList.builder();

        private Builder(String descriptor) {
            this.descriptor = descriptor;
        }

        public Builder immutableInput(UnboundRuleInput.Builder inputBuilder) {
            this.immutableInputs.add((Object)inputBuilder.build());
            return this;
        }

        public Builder mutableInput(UnboundRuleInput.Builder inputBuilder) {
            this.mutableInputs.add((Object)inputBuilder.build());
            return this;
        }

        public UnboundRule build() {
            return new UnboundRule(this.descriptor, (ImmutableList)this.immutableInputs.build(), (ImmutableList)this.mutableInputs.build());
        }
    }
}

