/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.os.OperatingSystem;

public enum SymbolExtractorOsConfig {
    OBJCOPY("objcopy", Lists.newArrayList("--only-keep-debug"), ".debug"),
    DSYMUTIL("dsymutil", Lists.newArrayList("-f"), ".dwarf"){

        @Override
        public List<String> getInputOutputFileArguments(String inputFilePath, String outputFilePath) {
            return Lists.newArrayList("-o", outputFilePath, inputFilePath);
        }
    };

    private static final OperatingSystem OS;
    private final String executable;
    private final List<String> arguments;
    private final String extension;

    private SymbolExtractorOsConfig(String executable, List<String> arguments, String extension) {
        this.executable = executable;
        this.arguments = arguments;
        this.extension = extension;
    }

    public static SymbolExtractorOsConfig current() {
        if (OS.isMacOsX()) {
            return DSYMUTIL;
        }
        return OBJCOPY;
    }

    public String getExecutableName() {
        return this.executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getInputOutputFileArguments(String inputFilePath, String outputFilePath) {
        return Lists.newArrayList(inputFilePath, outputFilePath);
    }

    public String getExtension() {
        return this.extension;
    }

    static {
        OS = OperatingSystem.current();
    }
}

