/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.util.Path;

public class DefaultComponentSpecIdentifier
implements ComponentSpecIdentifier {
    private final DefaultComponentSpecIdentifier parent;
    private final String projectPath;
    private final String name;

    public DefaultComponentSpecIdentifier(String projectPath, String name) {
        this(projectPath, null, name);
    }

    private DefaultComponentSpecIdentifier(String projectPath, DefaultComponentSpecIdentifier parent, String name) {
        this.projectPath = projectPath;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public ComponentSpecIdentifier child(String name) {
        return new DefaultComponentSpecIdentifier(this.projectPath, this, name);
    }

    @Override
    @Nullable
    public ComponentSpecIdentifier getParent() {
        return this.parent;
    }

    @Override
    public Path getPath() {
        return Path.path(this.getQualifiedPath());
    }

    private String getQualifiedPath() {
        return this.parent == null ? this.name : this.parent.getQualifiedPath() + ":" + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProjectScopedName() {
        return this.parent == null ? this.name : this.parent.getProjectScopedName() + StringUtils.capitalize(this.name);
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    public String toString() {
        return this.getQualifiedPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultComponentSpecIdentifier)) {
            return false;
        }
        DefaultComponentSpecIdentifier that = (DefaultComponentSpecIdentifier)o;
        return this.name.equals(that.name) && this.projectPath.equals(that.projectPath) && Objects.equal(this.parent, that.parent);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = this.parent != null ? 31 * result + this.parent.hashCode() : 31 * result + this.projectPath.hashCode();
        return result;
    }
}

