/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.dependents;

import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;

public class DefaultDependentBinariesResolvedResult
implements DependentBinariesResolvedResult {
    private final LibraryBinaryIdentifier identifier;
    private final String projectScopeName;
    private final boolean buildable;
    private final boolean testSuite;
    private final List<DependentBinariesResolvedResult> children;

    public DefaultDependentBinariesResolvedResult(LibraryBinaryIdentifier identifier, String projectScopeName, boolean buildable, boolean testSuite, List<DependentBinariesResolvedResult> children) {
        Preconditions.checkNotNull(identifier, "Binary identifier must be non null");
        Preconditions.checkNotNull(Strings.emptyToNull(projectScopeName), "Name must be non empty");
        this.identifier = identifier;
        this.projectScopeName = projectScopeName;
        this.buildable = buildable;
        this.testSuite = testSuite;
        this.children = children != null ? children : Collections.emptyList();
    }

    @Override
    public LibraryBinaryIdentifier getId() {
        return this.identifier;
    }

    @Override
    public String getProjectScopedName() {
        return this.projectScopeName;
    }

    @Override
    public boolean isBuildable() {
        return this.buildable;
    }

    @Override
    public boolean isTestSuite() {
        return this.testSuite;
    }

    @Override
    public List<DependentBinariesResolvedResult> getChildren() {
        return this.children;
    }
}

