/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.javascript;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.JavaScriptCompileDestinationCalculator;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.plugins.javascript.base.SourceTransformationException;
import org.gradle.util.GFileUtils;

public class GoogleClosureCompiler
implements Compiler<JavaScriptCompileSpec>,
Serializable {
    private static final String DEFAULT_GOOGLE_CLOSURE_VERSION = "v20141215";
    private Class<?> sourceFileClass;
    private Class<?> compilerOptionsClass;
    private Class<Enum> compilationLevelClass;
    private Class<Object> compilerClass;

    public static Object getDependencyNotation() {
        return "com.google.javascript:closure-compiler:v20141215";
    }

    @Override
    public WorkResult execute(JavaScriptCompileSpec spec) {
        JavaScriptCompileDestinationCalculator destinationCalculator = new JavaScriptCompileDestinationCalculator(spec.getDestinationDir());
        ArrayList<String> allErrors = Lists.newArrayList();
        for (RelativeFile sourceFile : spec.getSources()) {
            allErrors.addAll(this.compile(sourceFile, spec, destinationCalculator));
        }
        if (allErrors.isEmpty()) {
            return WorkResults.didWork(true);
        }
        throw new SourceTransformationException(String.format("Minification failed with the following errors:\n\t%s", StringUtils.join(allErrors, "\n\t")), null);
    }

    List<String> compile(RelativeFile javascriptFile, JavaScriptCompileSpec spec, JavaScriptCompileDestinationCalculator destinationCalculator) {
        ArrayList<String> errors = Lists.newArrayList();
        this.loadCompilerClasses(this.getClass().getClassLoader());
        JavaMethod<?, Object> fromCodeJavaMethod = JavaMethod.ofStatic(this.sourceFileClass, Object.class, "fromCode", String.class, String.class);
        Object extern = fromCodeJavaMethod.invokeStatic("/dev/null", "");
        JavaMethod<?, Object> fromFileJavaMethod = JavaMethod.ofStatic(this.sourceFileClass, Object.class, "fromFile", File.class);
        Object sourceFile = fromFileJavaMethod.invokeStatic(javascriptFile.getFile());
        Object compilerOptions = DirectInstantiator.INSTANCE.newInstance(this.compilerOptionsClass, new Object[0]);
        Enum simpleLevel = Enum.valueOf(this.compilationLevelClass, "SIMPLE_OPTIMIZATIONS");
        JavaMethod<Class<Enum>, Void> setOptionsForCompilationLevelMethod = JavaMethod.of(this.compilationLevelClass, Void.class, "setOptionsForCompilationLevel", new Class[]{this.compilerOptionsClass});
        setOptionsForCompilationLevelMethod.invoke((Class<Enum>)((Object)simpleLevel), compilerOptions);
        Object compiler = DirectInstantiator.INSTANCE.newInstance(this.compilerClass, this.getDummyPrintStream());
        JavaMethod<Class<Object>, Object> compileMethod = JavaMethod.of(this.compilerClass, Object.class, "compile", new Class[]{this.sourceFileClass, this.sourceFileClass, this.compilerOptionsClass});
        Object result = compileMethod.invoke((Class<Object>)compiler, extern, sourceFile, compilerOptions);
        Object[] jsErrors = (Object[])GoogleClosureCompiler.getFieldValue(result, "errors");
        if (jsErrors.length == 0) {
            JavaMethod<Class<Object>, String> toSourceMethod = JavaMethod.of(this.compilerClass, String.class, "toSource", new Class[0]);
            String compiledSource = toSourceMethod.invoke((Class<Object>)compiler, new Object[0]);
            GFileUtils.writeFile(compiledSource, destinationCalculator.transform(javascriptFile));
        } else {
            for (Object error : jsErrors) {
                errors.add(error.toString());
            }
        }
        return errors;
    }

    private static <T> T getFieldValue(Object result, String fieldName) {
        try {
            Field field = result.getClass().getField(fieldName);
            return Cast.uncheckedCast(field.get(result));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private void loadCompilerClasses(ClassLoader cl) {
        try {
            Class<?> clazz;
            if (this.sourceFileClass == null) {
                this.sourceFileClass = cl.loadClass("com.google.javascript.jscomp.SourceFile");
            }
            if (this.compilerOptionsClass == null) {
                this.compilerOptionsClass = cl.loadClass("com.google.javascript.jscomp.CompilerOptions");
            }
            if (this.compilationLevelClass == null) {
                clazz = cl.loadClass("com.google.javascript.jscomp.CompilationLevel");
                this.compilationLevelClass = clazz;
            }
            if (this.compilerClass == null) {
                clazz = cl.loadClass("com.google.javascript.jscomp.Compiler");
                this.compilerClass = clazz;
            }
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private PrintStream getDummyPrintStream() {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        return new PrintStream(os);
    }
}

