/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.spec;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.reporting.components.internal.AbstractBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.play.PlayApplicationBinarySpec;

public class PlayApplicationBinaryRenderer
extends AbstractBinaryRenderer<PlayApplicationBinarySpec> {
    @Inject
    public PlayApplicationBinaryRenderer(ModelSchemaStore schemaStore) {
        super(schemaStore);
    }

    @Override
    protected void renderDetails(PlayApplicationBinarySpec binary, TextReportBuilder builder) {
        builder.item("toolchain", binary.getToolChain().getDisplayName());
    }

    @Override
    protected void renderOutputs(PlayApplicationBinarySpec binary, TextReportBuilder builder) {
        builder.item("classes dir", binary.getClasses().getClassesDir());
        for (File dir2 : binary.getClasses().getResourceDirs()) {
            builder.item("resources dir", dir2);
        }
        builder.item("JAR file", binary.getJarFile());
    }

    @Override
    public Class<PlayApplicationBinarySpec> getTargetType() {
        return PlayApplicationBinarySpec.class;
    }
}

