/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaOptionInvocationWrapper;
import org.gradle.util.CollectionUtils;

public class TwirlCompiler
implements Compiler<TwirlCompileSpec>,
Serializable {
    private final VersionedTwirlCompilerAdapter adapter;

    @Inject
    public TwirlCompiler(VersionedTwirlCompilerAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public WorkResult execute(TwirlCompileSpec spec) {
        ArrayList<File> outputFiles = Lists.newArrayList();
        ClassLoader cl = this.getClass().getClassLoader();
        ScalaMethod compile = this.getCompileMethod(cl);
        Iterable<RelativeFile> sources = spec.getSources();
        for (RelativeFile sourceFile : sources) {
            TwirlTemplateFormat format = this.findTemplateFormat(spec, sourceFile.getFile());
            try {
                Object result = compile.invoke(this.buildCompileArguments(spec, cl, sourceFile, format));
                ScalaOptionInvocationWrapper maybeFile = new ScalaOptionInvocationWrapper(result);
                if (!maybeFile.isDefined()) continue;
                File outputFile = (File)maybeFile.get();
                outputFiles.add(outputFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking Play Twirl template compiler.", e);
            }
        }
        return WorkResults.didWork(!outputFiles.isEmpty());
    }

    private ScalaMethod getCompileMethod(ClassLoader cl) {
        try {
            return this.adapter.getCompileMethod(cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error invoking Play Twirl template compiler.", e);
        }
    }

    private Object[] buildCompileArguments(TwirlCompileSpec spec, ClassLoader cl, RelativeFile sourceFile, TwirlTemplateFormat format) {
        try {
            return this.adapter.createCompileParameters(cl, sourceFile.getFile(), sourceFile.getBaseDir(), spec.getDestinationDir(), spec.getDefaultImports(), format, spec.getAdditionalImports());
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking Play Twirl template compiler.", e);
        }
    }

    private TwirlTemplateFormat findTemplateFormat(TwirlCompileSpec spec, final File sourceFile) {
        Spec<TwirlTemplateFormat> hasExtension = new Spec<TwirlTemplateFormat>(){

            @Override
            public boolean isSatisfiedBy(TwirlTemplateFormat format) {
                return FileUtils.hasExtensionIgnoresCase(sourceFile.getName(), "." + format.getExtension());
            }
        };
        TwirlTemplateFormat format = CollectionUtils.findFirst(this.adapter.getDefaultTemplateFormats(), hasExtension);
        if (format == null) {
            format = CollectionUtils.findFirst(spec.getUserTemplateFormats(), hasExtension);
        }
        Preconditions.checkNotNull(format, "Twirl compiler could not find a matching template for '%s'.", (Object)sourceFile.getName());
        return format;
    }
}

